/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.ExclusiveSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFile
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "files";
    }

    public void configSectionSave() {
    }

    public int maxUserMode() {
        return 2;
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    public Composite configSectionCreate(final Composite parent) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        ArrayList<String> allConfigIDs = new ArrayList<String>();
        Composite gFile = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        gFile.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Group gDefaultDir = new Group(gFile, 0);
        Messages.setLanguageText((Widget)gDefaultDir, "ConfigView.section.file.defaultdir.section");
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        gDefaultDir.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gDefaultDir.setLayoutData((Object)gridData);
        String sCurConfigID = "Default save path";
        allConfigIDs.add(sCurConfigID);
        Label lblDefaultDir = new Label((Composite)gDefaultDir, 0);
        Messages.setLanguageText((Widget)lblDefaultDir, "ConfigView.section.file.defaultdir.ask");
        lblDefaultDir.setLayoutData((Object)new GridData());
        gridData = new GridData(768);
        final StringParameter pathParameter = new StringParameter((Composite)gDefaultDir, sCurConfigID);
        pathParameter.setLayoutData(gridData);
        Button browse = new Button((Composite)gDefaultDir, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setMessage(MessageText.getString("ConfigView.dialog.choosedefaultsavepath"));
                dialog.setText(MessageText.getString("ConfigView.section.file.defaultdir.ask"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        sCurConfigID = "Use default data dir";
        allConfigIDs.add(sCurConfigID);
        BooleanParameter autoSaveToDir = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.auto");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        autoSaveToDir.setLayoutData(gridData);
        sCurConfigID = "DefaultDir.AutoSave.AutoRename";
        allConfigIDs.add(sCurConfigID);
        BooleanParameter autoSaveAutoRename = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.autorename");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 20;
        autoSaveAutoRename.setLayoutData(gridData);
        ChangeSelectionActionPerformer aapDefaultDirStuff3 = new ChangeSelectionActionPerformer(autoSaveAutoRename.getControls(), false);
        autoSaveToDir.setAdditionalActionPerformer(aapDefaultDirStuff3);
        sCurConfigID = "DefaultDir.BestGuess";
        allConfigIDs.add(sCurConfigID);
        BooleanParameter bestGuess = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.bestguess");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        bestGuess.setLayoutData(gridData);
        ChangeSelectionActionPerformer aapDefaultDirStuff = new ChangeSelectionActionPerformer(bestGuess.getControls(), true);
        autoSaveToDir.setAdditionalActionPerformer(aapDefaultDirStuff);
        sCurConfigID = "DefaultDir.AutoUpdate";
        allConfigIDs.add(sCurConfigID);
        BooleanParameter autoUpdateSaveDir = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.lastused");
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        autoUpdateSaveDir.setLayoutData(gridData);
        ChangeSelectionActionPerformer aapDefaultDirStuff2 = new ChangeSelectionActionPerformer(autoUpdateSaveDir.getControls(), true);
        autoSaveToDir.setAdditionalActionPerformer(aapDefaultDirStuff2);
        sCurConfigID = "XFS Allocation";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0 && !Constants.isWindows) {
            BooleanParameter xfsAllocation = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.xfs.allocation");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            xfsAllocation.setLayoutData(gridData);
        }
        BooleanParameter zeroNew = null;
        sCurConfigID = "Zero New";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            zeroNew = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.zeronewfiles");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            zeroNew.setLayoutData(gridData);
        }
        sCurConfigID = "File.truncate.if.too.large";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter truncateLarge = new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.truncate.too.large");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            truncateLarge.setLayoutData(gridData);
        }
        sCurConfigID = "Enable incremental file creation";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter incremental = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.incrementalfile");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            incremental.setLayoutData(gridData);
            Button[] btnIncremental = new Button[]{(Button)incremental.getControl()};
            zeroNew.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnIncremental));
            Button[] btnZeroNew = new Button[]{(Button)zeroNew.getControl()};
            incremental.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnZeroNew));
        }
        sCurConfigID = "Check Pieces on Completion";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter checkOnComp = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.checkOncompletion");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            checkOnComp.setLayoutData(gridData);
        }
        sCurConfigID = "Seeding Piece Check Recheck Enable";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter checkOnSeeding = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.checkOnSeeding");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            checkOnSeeding.setLayoutData(gridData);
        }
        sCurConfigID = "File.strict.locking";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 1) {
            BooleanParameter strictLocking = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.strictfilelocking");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            strictLocking.setLayoutData(gridData);
        }
        if (userMode == 0) {
            allConfigIDs.add("Use Resume");
            sCurConfigID = "Save Resume Interval";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "On Resume Recheck All";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "File.save.peers.enable";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "File.save.peers.max";
            allConfigIDs.add(sCurConfigID);
        } else {
            sCurConfigID = "Use Resume";
            allConfigIDs.add(sCurConfigID);
            final BooleanParameter bpUseResume = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.usefastresume");
            bpUseResume.setLayoutData(new GridData(2));
            Composite cResumeGroup = new Composite(gFile, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 4;
            layout.numColumns = 3;
            cResumeGroup.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalIndent = 25;
            gridData.horizontalSpan = 2;
            cResumeGroup.setLayoutData((Object)gridData);
            sCurConfigID = "Save Resume Interval";
            allConfigIDs.add(sCurConfigID);
            Label lblSaveResumeInterval = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblSaveResumeInterval, "ConfigView.label.saveresumeinterval");
            IntParameter paramSaveInterval = new IntParameter(cResumeGroup, sCurConfigID);
            gridData = new GridData();
            gridData.widthHint = 30;
            paramSaveInterval.setLayoutData(gridData);
            Label lblMinutes = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblMinutes, "ConfigView.text.minutes");
            sCurConfigID = "On Resume Recheck All";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter recheck_all = new BooleanParameter(cResumeGroup, sCurConfigID, "ConfigView.section.file.resume.recheck.all");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            recheck_all.setLayoutData(gridData);
            sCurConfigID = "File.save.peers.enable";
            allConfigIDs.add(sCurConfigID);
            final BooleanParameter save_peers = new BooleanParameter(cResumeGroup, sCurConfigID, "ConfigView.section.file.save.peers.enable");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            save_peers.setLayoutData(gridData);
            sCurConfigID = "File.save.peers.max";
            allConfigIDs.add(sCurConfigID);
            final Label lblSavePeersMax = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblSavePeersMax, "ConfigView.section.file.save.peers.max");
            final IntParameter savePeersMax = new IntParameter(cResumeGroup, sCurConfigID);
            gridData = new GridData();
            gridData.widthHint = 30;
            savePeersMax.setLayoutData(gridData);
            final Label lblPerTorrent = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblPerTorrent, "ConfigView.section.file.save.peers.pertorrent");
            Control[] controls = new Control[]{cResumeGroup};
            GenericActionPerformer f_enabler = new GenericActionPerformer(controls){

                public void performAction() {
                    this.controlsSetEnabled(this.controls, bpUseResume.isSelected());
                    if (bpUseResume.isSelected()) {
                        lblSavePeersMax.setEnabled(save_peers.isSelected());
                        savePeersMax.getControl().setEnabled(save_peers.isSelected());
                        lblPerTorrent.setEnabled(save_peers.isSelected());
                    }
                }
            };
            bpUseResume.setAdditionalActionPerformer(f_enabler);
            save_peers.setAdditionalActionPerformer(f_enabler);
        }
        if (userMode > 0) {
            sCurConfigID = "priorityExtensions";
            allConfigIDs.add(sCurConfigID);
            Label label = new Label(gFile, 64);
            gridData = new GridData();
            gridData.widthHint = 180;
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.priorityExtensions");
            Composite cExtensions = new Composite(gFile, 0);
            gridData = new GridData(768);
            cExtensions.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            cExtensions.setLayout((Layout)layout);
            gridData = new GridData(768);
            new StringParameter(cExtensions, sCurConfigID).setLayoutData(gridData);
            sCurConfigID = "priorityExtensionsIgnoreCase";
            allConfigIDs.add(sCurConfigID);
            new BooleanParameter(cExtensions, sCurConfigID, "ConfigView.label.ignoreCase");
        } else {
            sCurConfigID = "priorityExtensions";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "priorityExtensionsIgnoreCase";
            allConfigIDs.add(sCurConfigID);
        }
        sCurConfigID = "Rename Incomplete Files";
        allConfigIDs.add(sCurConfigID);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        BooleanParameter rename_incomplete = new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.rename.incomplete");
        rename_incomplete.setLayoutData(gridData);
        sCurConfigID = "Rename Incomplete Files Extension";
        allConfigIDs.add(sCurConfigID);
        gridData = new GridData(768);
        StringParameter rename_incomplete_ext = new StringParameter(gFile, sCurConfigID);
        rename_incomplete_ext.setLayoutData(gridData);
        ChangeSelectionActionPerformer incompFileAP = new ChangeSelectionActionPerformer(rename_incomplete_ext.getControls(), false);
        rename_incomplete.setAdditionalActionPerformer(incompFileAP);
        sCurConfigID = "Confirm Data Delete";
        allConfigIDs.add(sCurConfigID);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.confirm_data_delete").setLayoutData(gridData);
        sCurConfigID = "File.delete.include_files_outside_save_dir";
        allConfigIDs.add(sCurConfigID);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.delete.include_files_outside_save_dir").setLayoutData(gridData);
        if (userMode > 0) {
            Label lIgnoreFiles = new Label(gFile, 0);
            Messages.setLanguageText((Widget)lIgnoreFiles, "ConfigView.section.file.torrent.ignorefiles");
            gridData = new GridData(768);
            new StringParameter(gFile, "File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini").setLayoutData(gridData);
        }
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                sCurConfigID = "Move Deleted Data To Recycle Bin";
                allConfigIDs.add(sCurConfigID);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.nativedelete").setLayoutData(gridData);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (userMode > 0) {
            Group gConfigSettings = new Group(gFile, 0);
            Messages.setLanguageText((Widget)gConfigSettings, "ConfigView.section.file.config.section");
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            gConfigSettings.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gConfigSettings.setLayoutData((Object)gridData);
            Label config_label = new Label((Composite)gConfigSettings, 0);
            Messages.setLanguageText((Widget)config_label, "ConfigView.section.file.config.currentdir");
            config_label.setLayoutData((Object)new GridData());
            Label config_link = new Label((Composite)gConfigSettings, 0);
            config_link.setText(SystemProperties.getUserPath());
            config_link.setLayoutData((Object)new GridData());
            LinkLabel.makeLinkedLabel(config_link, SystemProperties.getUserPath());
            sCurConfigID = "Use Config File Backups";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter backupConfig = new BooleanParameter((Composite)gConfigSettings, sCurConfigID, "ConfigView.label.backupconfigfiles");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            backupConfig.setLayoutData(gridData);
        }
        return gFile;
    }
}

