/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.IPFilterListener;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManager;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.FloatParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.IpFilterEditor;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionIPFilter
implements UISWTConfigSection {
    IpFilter filter;
    Table table;
    boolean noChange;
    FilterComparator comparator = new FilterComparator();
    private boolean bIsCachingDescriptions = false;
    IpRange[] ipRanges;
    Label percentage_blocked;
    private IPFilterListener filterListener;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "ipfilter";
    }

    public void configSectionSave() {
        try {
            if (this.filter != null) {
                this.filter.save();
            }
        }
        catch (Exception e) {
            Logger.log(new LogAlert(false, "Save of filter file fails", e));
        }
    }

    public int maxUserMode() {
        return 1;
    }

    public void configSectionDelete() {
        if (this.bIsCachingDescriptions) {
            IpFilterManager ipFilterManager = AzureusCoreFactory.getSingleton().getIpFilterManager();
            ipFilterManager.clearDescriptionCache();
            this.bIsCachingDescriptions = false;
        }
        if (this.filter != null) {
            this.filter.removeListener(this.filterListener);
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
        imageLoader.releaseImage("subitem");
    }

    public Composite configSectionCreate(final Composite parent) {
        if (!AzureusCoreFactory.isCoreRunning()) {
            Composite cSection = new Composite(parent, 0);
            cSection.setLayout((Layout)new FillLayout());
            Label lblNotAvail = new Label(cSection, 64);
            Messages.setLanguageText((Widget)lblNotAvail, "core.not.available");
            return cSection;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final IpFilterManager ipFilterManager = AzureusCoreFactory.getSingleton().getIpFilterManager();
        this.filter = ipFilterManager.getIPFilter();
        Composite gFilter = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        gFilter.setLayout((Layout)layout);
        GridData gridData = new GridData(272);
        gFilter.setLayoutData((Object)gridData);
        gridData = new GridData();
        BooleanParameter enabled = new BooleanParameter(gFilter, "Ip Filter Enabled");
        enabled.setLayoutData(gridData);
        Messages.setLanguageText((Widget)enabled.getControl(), "ConfigView.section.ipfilter.enable");
        gridData = new GridData();
        BooleanParameter deny = new BooleanParameter(gFilter, "Ip Filter Allow");
        deny.setLayoutData(gridData);
        Messages.setLanguageText((Widget)deny.getControl(), "ConfigView.section.ipfilter.allow");
        deny.addChangeListener(new ParameterChangeAdapter(){

            public void parameterChanged(Parameter p, boolean caused_internally) {
                ConfigSectionIPFilter.this.setPercentageBlocked();
            }
        });
        gridData = new GridData();
        BooleanParameter persist_bad_data_banning = new BooleanParameter(gFilter, "Ip Filter Banning Persistent");
        persist_bad_data_banning.setLayoutData(gridData);
        Messages.setLanguageText((Widget)persist_bad_data_banning.getControl(), "ConfigView.section.ipfilter.persistblocking");
        Group gBlockBanning = new Group(gFilter, 0);
        Messages.setLanguageText((Widget)gBlockBanning, "ConfigView.section.ipfilter.peerblocking.group");
        layout = new GridLayout();
        layout.numColumns = 2;
        gBlockBanning.setLayout((Layout)layout);
        BooleanParameter enable_bad_data_banning = new BooleanParameter((Composite)gBlockBanning, "Ip Filter Enable Banning", "ConfigView.section.ipfilter.enablebanning");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_bad_data_banning.setLayoutData(gridData);
        Label discard_label = new Label((Composite)gBlockBanning, 0);
        Messages.setLanguageText((Widget)discard_label, "ConfigView.section.ipfilter.discardbanning");
        FloatParameter discard_ratio = new FloatParameter((Composite)gBlockBanning, "Ip Filter Ban Discard Ratio");
        gridData = new GridData();
        gridData.widthHint = 30;
        discard_ratio.setLayoutData(gridData);
        Composite cIndent = new Composite((Composite)gBlockBanning, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 15;
        cIndent.setLayoutData((Object)gridData);
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cIndent.setLayout((Layout)layout);
        Image img = imageLoader.getImage("subitem");
        Label label = new Label(cIndent, 0);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        label.setImage(img);
        Label discard_min_label = new Label(cIndent, 0);
        Messages.setLanguageText((Widget)discard_min_label, "ConfigView.section.ipfilter.discardminkb", new String[]{DisplayFormatters.getUnit(1)});
        IntParameter discard_min = new IntParameter(cIndent, "Ip Filter Ban Discard Min KB");
        gridData = new GridData();
        gridData.widthHint = 30;
        discard_min.setLayoutData(gridData);
        Label block_label = new Label((Composite)gBlockBanning, 0);
        Messages.setLanguageText((Widget)block_label, "ConfigView.section.ipfilter.blockbanning");
        IntParameter block_banning = new IntParameter((Composite)gBlockBanning, "Ip Filter Ban Block Limit");
        gridData = new GridData();
        gridData.widthHint = 30;
        block_banning.setLayoutData(gridData);
        enable_bad_data_banning.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{block_banning.getControl(), block_label, discard_ratio.getControl(), discard_label, discard_min.getControl(), discard_min_label}));
        Group gAutoLoad = new Group(gFilter, 0);
        Messages.setLanguageText((Widget)gAutoLoad, "ConfigView.section.ipfilter.autoload.group");
        layout = new GridLayout();
        layout.numColumns = 4;
        gAutoLoad.setLayout((Layout)layout);
        gAutoLoad.setLayoutData((Object)new GridData(256));
        String sCurConfigID = "Ip Filter Autoload File";
        Label lblDefaultDir = new Label((Composite)gAutoLoad, 0);
        Messages.setLanguageText((Widget)lblDefaultDir, "ConfigView.section.ipfilter.autoload.file");
        lblDefaultDir.setLayoutData((Object)new GridData());
        gridData = new GridData(768);
        gridData.minimumWidth = 50;
        final StringParameter pathParameter = new StringParameter((Composite)gAutoLoad, sCurConfigID);
        pathParameter.setLayoutData(gridData);
        Button browse = new Button((Composite)gAutoLoad, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.ipfilter.autoload.file"));
                dialog.setFilterExtensions(new String[]{"*.dat" + File.pathSeparator + "*.p2p" + File.pathSeparator + "*.p2b" + File.pathSeparator + "*.txt", "*.*"});
                dialog.setFileName("ipfilter.dat");
                String file = dialog.open();
                if (file != null) {
                    pathParameter.setValue(file);
                }
            }
        });
        browse.setLayoutData((Object)new GridData());
        final Button btnLoadNow = new Button((Composite)gAutoLoad, 8);
        Messages.setLanguageText((Widget)btnLoadNow, "ConfigView.section.ipfilter.autoload.loadnow");
        btnLoadNow.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                try {
                    btnLoadNow.getShell().setCursor(btnLoadNow.getDisplay().getSystemCursor(1));
                    COConfigurationManager.setParameter("Ip Filter Autoload Last Date", 0);
                    ConfigSectionIPFilter.this.filter.reload();
                    btnLoadNow.getShell().setCursor(btnLoadNow.getDisplay().getSystemCursor(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        btnLoadNow.setLayoutData((Object)new GridData());
        Label lblAutoLoadInfo = new Label((Composite)gAutoLoad, 64);
        Messages.setLanguageText((Widget)lblAutoLoadInfo, "ConfigView.section.ipfilter.autoload.info");
        lblAutoLoadInfo.setLayoutData((Object)Utils.getWrappableLabelGridData(4, 0));
        if (userMode > 0) {
            gridData = new GridData();
            BooleanParameter enableDesc = new BooleanParameter(gFilter, "Ip Filter Enable Description Cache");
            enableDesc.setLayoutData(gridData);
            Messages.setLanguageText((Widget)enableDesc.getControl(), "ConfigView.section.ipfilter.enable.descriptionCache");
        }
        this.table = new Table(gFilter, 268503044);
        String[] headers = new String[]{"ConfigView.section.ipfilter.description", "ConfigView.section.ipfilter.start", "ConfigView.section.ipfilter.end"};
        int[] sizes = new int[]{110, 110, 110};
        int[] aligns = new int[]{16384, 0x1000000, 0x1000000};
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc = new TableColumn(this.table, aligns[i]);
            tc.setText(headers[i]);
            tc.setWidth(sizes[i]);
            Messages.setLanguageText((Widget)tc, headers[i]);
        }
        TableColumn[] columns = this.table.getColumns();
        columns[0].setData((Object)new Integer(0));
        columns[1].setData((Object)new Integer(1));
        columns[2].setData((Object)new Integer(2));
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn tc = (TableColumn)e.widget;
                int field = (Integer)tc.getData();
                ConfigSectionIPFilter.this.comparator.setField(field);
                if (field == 0 && !ConfigSectionIPFilter.this.bIsCachingDescriptions) {
                    ipFilterManager.cacheAllDescriptions();
                    ConfigSectionIPFilter.this.bIsCachingDescriptions = true;
                }
                ConfigSectionIPFilter.this.ipRanges = ConfigSectionIPFilter.this.getSortedRanges(ConfigSectionIPFilter.this.filter.getRanges());
                ConfigSectionIPFilter.this.table.setItemCount(ConfigSectionIPFilter.this.ipRanges.length);
                ConfigSectionIPFilter.this.table.clearAll();
                ConfigSectionIPFilter.this.table.redraw();
            }
        };
        columns[0].addListener(13, listener);
        columns[1].addListener(13, listener);
        columns[2].addListener(13, listener);
        this.table.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = this.table.getHeaderHeight() * 3;
        gridData.widthHint = 200;
        this.table.setLayoutData((Object)gridData);
        Composite cArea = new Composite(gFilter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout((Layout)layout);
        gridData = new GridData(768);
        cArea.setLayoutData((Object)gridData);
        Button add = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        add.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)add, "ConfigView.section.ipfilter.add");
        add.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ConfigSectionIPFilter.this.addRange();
            }
        });
        Button remove = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        remove.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)remove, "ConfigView.section.ipfilter.remove");
        remove.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.removeRange((IpRange)selection[0].getData());
                ConfigSectionIPFilter.this.ipRanges = ConfigSectionIPFilter.this.getSortedRanges(ConfigSectionIPFilter.this.filter.getRanges());
                ConfigSectionIPFilter.this.table.setItemCount(ConfigSectionIPFilter.this.ipRanges.length);
                ConfigSectionIPFilter.this.table.clearAll();
                ConfigSectionIPFilter.this.table.redraw();
            }
        });
        Button edit = new Button(cArea, 8);
        gridData = new GridData(2);
        gridData.widthHint = 100;
        edit.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)edit, "ConfigView.section.ipfilter.edit");
        edit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.editRange((IpRange)selection[0].getData());
            }
        });
        this.percentage_blocked = new Label(cArea, 131136);
        this.percentage_blocked.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 0));
        this.setPercentageBlocked();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                TableItem[] selection = ConfigSectionIPFilter.this.table.getSelection();
                if (selection.length == 0) {
                    return;
                }
                ConfigSectionIPFilter.this.editRange((IpRange)selection[0].getData());
            }
        });
        Control[] controls = new Control[]{add, remove, edit};
        ChangeSelectionActionPerformer enabler = new ChangeSelectionActionPerformer(controls);
        enabled.setAdditionalActionPerformer(enabler);
        this.ipRanges = this.getSortedRanges(this.filter.getRanges());
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = ConfigSectionIPFilter.this.table.indexOf(item);
                if (index < 0 || index >= ConfigSectionIPFilter.this.ipRanges.length) {
                    return;
                }
                IpRange range = ConfigSectionIPFilter.this.ipRanges[index];
                item.setText(0, range.getDescription());
                item.setText(1, range.getStartIp());
                item.setText(2, range.getEndIp());
                item.setData((Object)range);
            }
        });
        this.table.setItemCount(this.ipRanges.length);
        this.table.clearAll();
        this.table.redraw();
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ConfigSectionIPFilter.this.resizeTable();
            }
        });
        gFilter.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ConfigSectionIPFilter.this.resizeTable();
            }
        });
        this.filterListener = new IPFilterListener(){

            public boolean canIPBeBanned(String ip) {
                return true;
            }

            public void IPBanned(BannedIp ip) {
            }

            public void IPBlockedListChanged(final IpFilter filter) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (ConfigSectionIPFilter.this.table.isDisposed()) {
                            filter.removeListener(ConfigSectionIPFilter.this.filterListener);
                            return;
                        }
                        ConfigSectionIPFilter.this.ipRanges = ConfigSectionIPFilter.this.getSortedRanges(filter.getRanges());
                        ConfigSectionIPFilter.this.table.setItemCount(ConfigSectionIPFilter.this.ipRanges.length);
                        ConfigSectionIPFilter.this.table.clearAll();
                        ConfigSectionIPFilter.this.table.redraw();
                    }
                });
            }

            public boolean canIPBeBlocked(String ip, byte[] torrent_hash) {
                return true;
            }
        };
        this.filter.addListener(this.filterListener);
        return gFilter;
    }

    private void resizeTable() {
        int iNewWidth = this.table.getClientArea().width - this.table.getColumn(1).getWidth() - this.table.getColumn(2).getWidth() - 20;
        if (iNewWidth > 50) {
            this.table.getColumn(0).setWidth(iNewWidth);
        }
    }

    public void removeRange(IpRange range) {
        this.filter.removeRange(range);
    }

    public void editRange(IpRange range) {
        new IpFilterEditor(AzureusCoreFactory.getSingleton(), this.table.getShell(), range);
        this.noChange = false;
    }

    public void addRange() {
        new IpFilterEditor(AzureusCoreFactory.getSingleton(), this.table.getShell(), null);
    }

    public void refresh() {
        if (this.table == null || this.table.isDisposed() || this.noChange) {
            return;
        }
        this.noChange = true;
        TableItem[] items = this.table.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].isDisposed()) continue;
            String tmp = items[i].getText(0);
            IpRange range = (IpRange)items[i].getData();
            String desc = range.getDescription();
            if (desc != null && !desc.equals(tmp)) {
                items[i].setText(0, desc);
            }
            tmp = items[i].getText(1);
            if (range.getStartIp() != null && !range.getStartIp().equals(tmp)) {
                items[i].setText(1, range.getStartIp());
            }
            tmp = items[i].getText(2);
            if (range.getEndIp() == null || range.getEndIp().equals(tmp)) continue;
            items[i].setText(2, range.getEndIp());
        }
    }

    protected IpRange[] getSortedRanges(IpRange[] ranges) {
        Arrays.sort(ranges, this.comparator);
        return ranges;
    }

    protected void setPercentageBlocked() {
        long nbIPsBlocked = this.filter.getTotalAddressesInRange();
        if (COConfigurationManager.getBooleanParameter("Ip Filter Allow")) {
            nbIPsBlocked = 0x100000000L - nbIPsBlocked;
        }
        int percentIPsBlocked = (int)(nbIPsBlocked * 1000L / 0x100000000L);
        String nbIps = "" + nbIPsBlocked;
        String percentIps = DisplayFormatters.formatPercentFromThousands(percentIPsBlocked);
        Messages.setLanguageText((Widget)this.percentage_blocked, "ConfigView.section.ipfilter.totalIPs", new String[]{nbIps, percentIps});
    }

    class FilterComparator
    implements Comparator {
        boolean ascending = true;
        static final int FIELD_NAME = 0;
        static final int FIELD_START_IP = 1;
        static final int FIELD_END_IP = 2;
        int field = 1;

        FilterComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            IpRange range0 = (IpRange)arg0;
            IpRange range1 = (IpRange)arg1;
            if (this.field == 0) {
                return (this.ascending ? 1 : -1) * range0.compareDescription(range1);
            }
            if (this.field == 1) {
                return (this.ascending ? 1 : -1) * range0.compareStartIpTo(range1);
            }
            if (this.field == 2) {
                return (this.ascending ? 1 : -1) * range0.compareEndIpTo(range1);
            }
            return 0;
        }

        public void setField(int newField) {
            if (this.field == newField) {
                this.ascending = !this.ascending;
            }
            this.field = newField;
        }
    }
}

