/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfacePassword
implements UISWTConfigSection {
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    private final int REQUIRED_MODE = 0;
    Label passwordMatch;

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "interface.password";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cSection.setLayout((Layout)layout);
        Label label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.password");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw1 = new PasswordParameter(cSection, "Password");
        pw1.setLayoutData(gridData);
        Text t1 = (Text)pw1.getControl();
        label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordconfirm");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw2 = new PasswordParameter(cSection, "Password Confirm");
        pw2.setLayoutData(gridData);
        Text t2 = (Text)pw2.getControl();
        label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cSection, 0);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.passwordMatch.setLayoutData((Object)gridData);
        this.refreshPWLabel();
        t1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePassword.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterfacePassword.this.refreshPWLabel();
            }
        });
        return cSection;
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == confirm[i]) continue;
                    same = false;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

