/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTrackerClient
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "tracker";
    }

    public String configSectionGetName() {
        return "tracker.client";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite gMainTab = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gMainTab.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        gMainTab.setLayout((Layout)layout);
        Group scrapeGroup = new Group(gMainTab, 0);
        Messages.setLanguageText((Widget)scrapeGroup, "ConfigView.group.scrape");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        scrapeGroup.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        scrapeGroup.setLayoutData((Object)gridData);
        Label label = new Label((Composite)scrapeGroup, 64);
        label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
        Messages.setLanguageText((Widget)label, "ConfigView.section.tracker.client.scrapeinfo");
        BooleanParameter scrape = new BooleanParameter((Composite)scrapeGroup, "Tracker Client Scrape Enable", "ConfigView.section.tracker.client.scrapeenable");
        BooleanParameter scrape_stopped = new BooleanParameter((Composite)scrapeGroup, "Tracker Client Scrape Stopped Enable", "ConfigView.section.tracker.client.scrapestoppedenable");
        scrape.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(scrape_stopped.getControls()));
        new BooleanParameter((Composite)scrapeGroup, "Tracker Client Scrape Single Only", "ConfigView.section.tracker.client.scrapesingleonly");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(gMainTab, "Tracker Client Send OS and Java Version", "ConfigView.section.tracker.sendjavaversionandos").setLayoutData(gridData);
        label = new Label(gMainTab, 0);
        BooleanParameter enableUDP = new BooleanParameter(gMainTab, "Server Enable UDP", "ConfigView.section.server.enableudp");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableUDP.setLayoutData(gridData);
        label = new Label(gMainTab, 0);
        BooleanParameter showWarnings = new BooleanParameter(gMainTab, "Tracker Client Show Warnings", "ConfigView.section.tracker.client.showwarnings");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        showWarnings.setLayoutData(gridData);
        label = new Label(gMainTab, 0);
        if (userMode > 0) {
            Group overrideGroup = new Group(gMainTab, 0);
            Messages.setLanguageText((Widget)overrideGroup, "ConfigView.group.override");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            overrideGroup.setLayout((Layout)gridLayout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            overrideGroup.setLayoutData((Object)gridData);
            label = new Label((Composite)overrideGroup, 64);
            label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            Messages.setLanguageText((Widget)label, "ConfigView.label.overrideip");
            StringParameter overrideip = new StringParameter((Composite)overrideGroup, "Override Ip", "");
            GridData data = new GridData(768);
            data.widthHint = 100;
            overrideip.setLayoutData(data);
            label = new Label((Composite)overrideGroup, 64);
            label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            Messages.setLanguageText((Widget)label, "ConfigView.label.announceport");
            StringParameter tcpOverride = new StringParameter((Composite)overrideGroup, "TCP.Listen.Port.Override");
            data = new GridData();
            data.widthHint = 40;
            tcpOverride.setLayoutData(data);
            tcpOverride.addChangeListener(new ParameterChangeAdapter(){

                public void stringParameterChanging(Parameter p, String toValue) {
                    if (toValue == "") {
                        return;
                    }
                    try {
                        int portVal = Integer.parseInt(toValue);
                        if (portVal >= 0 && portVal <= 65535) {
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    p.setValue("");
                }
            });
            label = new Label((Composite)overrideGroup, 64);
            label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            Messages.setLanguageText((Widget)label, "ConfigView.label.noportannounce");
            BooleanParameter noPortAnnounce = new BooleanParameter((Composite)overrideGroup, "Tracker Client No Port Announce");
            data = new GridData();
            noPortAnnounce.setLayoutData(data);
            label = new Label((Composite)overrideGroup, 64);
            label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxnumwant");
            IntParameter numwant = new IntParameter((Composite)overrideGroup, "Tracker Client Numwant Limit", 0, 100);
            data = new GridData();
            data.widthHint = 40;
            numwant.setLayoutData(data);
            label = new Label((Composite)overrideGroup, 64);
            label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            Messages.setLanguageText((Widget)label, "ConfigView.label.minannounce");
            IntParameter minmininterval = new IntParameter((Composite)overrideGroup, "Tracker Client Min Announce Interval");
            data = new GridData();
            data.widthHint = 40;
            minmininterval.setLayoutData(data);
            if (userMode > 1) {
                label = new Label(gMainTab, 0);
                Messages.setLanguageText((Widget)label, "ConfigView.section.tracker.client.connecttimeout");
                gridData = new GridData();
                gridData.widthHint = 40;
                IntParameter connect_timeout = new IntParameter(gMainTab, "Tracker Client Connect Timeout");
                connect_timeout.setLayoutData(gridData);
                label = new Label(gMainTab, 0);
                label = new Label(gMainTab, 0);
                Messages.setLanguageText((Widget)label, "ConfigView.section.tracker.client.readtimeout");
                gridData = new GridData();
                gridData.widthHint = 40;
                IntParameter read_timeout = new IntParameter(gMainTab, "Tracker Client Read Timeout");
                read_timeout.setLayoutData(gridData);
                label = new Label(gMainTab, 0);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                new BooleanParameter(gMainTab, "Tracker Key Enable Client", "ConfigView.section.tracker.enablekey").setLayoutData(gridData);
                label = new Label(gMainTab, 0);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                new BooleanParameter(gMainTab, "Tracker Separate Peer IDs", "ConfigView.section.tracker.separatepeerids").setLayoutData(gridData);
                label = new Label(gMainTab, 64);
                label.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
                Messages.setLanguageText((Widget)label, "ConfigView.section.tracker.separatepeerids.info");
            }
        }
        return gMainTab;
    }
}

