/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class ConfigSectionTransfer
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "transfer";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("subitem");
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final int[] manual_max_download_speed = new int[]{COConfigurationManager.getIntParameter("Max Download Speed KBs")};
        gridData = new GridData();
        Label label = new Label(cSection, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploadspeed");
        gridData = new GridData();
        gridData.widthHint = 35;
        final IntParameter paramMaxUploadSpeed = new IntParameter(cSection, "Max Upload Speed KBs", 0, -1);
        paramMaxUploadSpeed.setLayoutData(gridData);
        Composite cMaxUploadSpeedOptionsArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cMaxUploadSpeedOptionsArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.horizontalSpan = 2;
        cMaxUploadSpeedOptionsArea.setLayoutData((Object)gridData);
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image img = imageLoader.getImage("subitem");
        label = new Label(cMaxUploadSpeedOptionsArea, 0);
        img.setBackground(label.getBackground());
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        label.setImage(img);
        gridData = new GridData();
        final BooleanParameter enable_seeding_rate = new BooleanParameter(cMaxUploadSpeedOptionsArea, "enable.seedingonly.upload.rate", "ConfigView.label.maxuploadspeedseeding");
        enable_seeding_rate.setLayoutData(gridData);
        gridData = new GridData();
        gridData.widthHint = 35;
        final IntParameter paramMaxUploadSpeedSeeding = new IntParameter(cMaxUploadSpeedOptionsArea, "Max Upload Speed Seeding KBs", 0, -1);
        paramMaxUploadSpeedSeeding.setLayoutData(gridData);
        enable_seeding_rate.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(paramMaxUploadSpeedSeeding.getControl()));
        if (userMode < 2) {
            Composite cWiki = new Composite(cSection, 15);
            gridData = new GridData(272);
            gridData.horizontalSpan = 2;
            cWiki.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            cWiki.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 6;
            gridData.horizontalSpan = 2;
            label = new Label(cWiki, 0);
            label.setLayoutData((Object)gridData);
            label.setText(MessageText.getString("Utils.link.visit") + ":");
            gridData = new GridData();
            gridData.horizontalIndent = 10;
            gridData.horizontalSpan = 2;
            new LinkLabel(cWiki, gridData, "ConfigView.section.transfer.speeds.wiki", "http://www.azureuswiki.com/index.php/Good_settings");
        }
        if (userMode > 1) {
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploadswhenbusymin");
            gridData = new GridData();
            gridData.widthHint = 35;
            new IntParameter(cSection, "max.uploads.when.busy.inc.min.secs", 0, -1).setLayoutData(gridData);
        }
        gridData = new GridData();
        label = new Label(cSection, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.maxdownloadspeed");
        gridData = new GridData();
        gridData.widthHint = 35;
        final IntParameter paramMaxDownSpeed = new IntParameter(cSection, "Max Download Speed KBs", 0, -1);
        paramMaxDownSpeed.setLayoutData(gridData);
        Listener l = new Listener(){

            public void handleEvent(Event event2) {
                boolean disableAuto = false;
                boolean disableAutoSeeding = false;
                if (enable_seeding_rate.isSelected()) {
                    disableAutoSeeding = event2.widget == paramMaxUploadSpeedSeeding.getControl();
                    disableAuto = event2.widget == paramMaxDownSpeed.getControl() || event2.widget == paramMaxUploadSpeed.getControl();
                } else {
                    disableAuto = true;
                    disableAutoSeeding = true;
                }
                if (disableAuto) {
                    COConfigurationManager.setParameter("Auto Upload Speed Enabled", false);
                }
                if (disableAutoSeeding) {
                    COConfigurationManager.setParameter("Auto Upload Speed Seeding Enabled", false);
                }
            }
        };
        paramMaxDownSpeed.getControl().addListener(13, l);
        paramMaxUploadSpeed.getControl().addListener(13, l);
        paramMaxUploadSpeedSeeding.getControl().addListener(13, l);
        paramMaxUploadSpeed.addChangeListener(new ParameterChangeAdapter(){
            ParameterChangeAdapter me = this;

            public void parameterChanged(Parameter p, boolean internal) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        if (paramMaxUploadSpeed.isDisposed()) {
                            paramMaxUploadSpeed.removeChangeListener(me);
                            return;
                        }
                        if (TransferSpeedValidator.isAutoSpeedActive(core.getGlobalManager())) {
                            return;
                        }
                        int up_val = paramMaxUploadSpeed.getValue();
                        int down_val = paramMaxDownSpeed.getValue();
                        if (up_val != 0 && up_val < 5) {
                            if (down_val == 0 || down_val > up_val * 2) {
                                paramMaxDownSpeed.setValue(up_val * 2);
                            }
                        } else if (down_val != manual_max_download_speed[0]) {
                            paramMaxDownSpeed.setValue(manual_max_download_speed[0]);
                        }
                    }
                });
            }
        });
        paramMaxDownSpeed.addChangeListener(new ParameterChangeAdapter(){
            ParameterChangeAdapter me = this;

            public void parameterChanged(Parameter p, boolean internal) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        int down_val;
                        if (paramMaxDownSpeed.isDisposed()) {
                            paramMaxDownSpeed.removeChangeListener(me);
                            return;
                        }
                        if (TransferSpeedValidator.isAutoSpeedActive(core.getGlobalManager())) {
                            return;
                        }
                        int up_val = paramMaxUploadSpeed.getValue();
                        manual_max_download_speed[0] = down_val = paramMaxDownSpeed.getValue();
                        if (up_val < 5) {
                            if (up_val != 0 && up_val < down_val * 2) {
                                paramMaxUploadSpeed.setValue((down_val + 1) / 2);
                            } else if (down_val == 0) {
                                paramMaxUploadSpeed.setValue(0);
                            }
                        }
                    }
                });
            }
        });
        if (userMode > 0) {
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploads");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxUploads = new IntParameter(cSection, "Max Uploads", 2, -1);
            paramMaxUploads.setLayoutData(gridData);
            Composite cMaxUploadsOptionsArea = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxUploadsOptionsArea, 0);
            img.setBackground(label.getBackground());
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            label.setImage(img);
            gridData = new GridData();
            BooleanParameter enable_seeding_uploads = new BooleanParameter(cMaxUploadsOptionsArea, "enable.seedingonly.maxuploads", "ConfigView.label.maxuploadsseeding");
            enable_seeding_uploads.setLayoutData(gridData);
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxUploadsSeeding = new IntParameter(cMaxUploadsOptionsArea, "Max Uploads Seeding", 2, -1);
            paramMaxUploadsSeeding.setLayoutData(gridData);
            enable_seeding_uploads.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(paramMaxUploadsSeeding.getControl()));
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.max_peers_per_torrent");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxClients = new IntParameter(cSection, "Max.Peer.Connections.Per.Torrent");
            paramMaxClients.setLayoutData(gridData);
            Composite cMaxPeersOptionsArea = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxPeersOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxPeersOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxPeersOptionsArea, 0);
            img.setBackground(label.getBackground());
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            label.setImage(img);
            gridData = new GridData();
            BooleanParameter enable_max_peers_seeding = new BooleanParameter(cMaxPeersOptionsArea, "Max.Peer.Connections.Per.Torrent.When.Seeding.Enable", "ConfigView.label.maxuploadsseeding");
            enable_max_peers_seeding.setLayoutData(gridData);
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxPeersSeeding = new IntParameter(cMaxPeersOptionsArea, "Max.Peer.Connections.Per.Torrent.When.Seeding", 0, -1);
            paramMaxPeersSeeding.setLayoutData(gridData);
            enable_max_peers_seeding.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(paramMaxPeersSeeding.getControl()));
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.max_peers_total");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxClientsTotal = new IntParameter(cSection, "Max.Peer.Connections.Total");
            paramMaxClientsTotal.setLayoutData(gridData);
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxseedspertorrent");
            gridData = new GridData();
            gridData.widthHint = 35;
            new IntParameter(cSection, "Max Seeds Per Torrent").setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter useReqLimiting = new BooleanParameter(cSection, "Use Request Limiting", "ConfigView.label.userequestlimiting");
            useReqLimiting.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter useReqLimitingPrios = new BooleanParameter(cSection, "Use Request Limiting Priorities", "ConfigView.label.userequestlimitingpriorities");
            useReqLimitingPrios.setLayoutData(gridData);
            useReqLimiting.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(useReqLimitingPrios.getControl()));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter allowSameIP = new BooleanParameter(cSection, "Allow Same IP Peers", "ConfigView.label.allowsameip");
            allowSameIP.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter lazybf = new BooleanParameter(cSection, "Use Lazy Bitfield", "ConfigView.label.lazybitfield");
            lazybf.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter firstPiece = new BooleanParameter(cSection, "Prioritize First Piece", "ConfigView.label.prioritizefirstpiece");
            firstPiece.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter mostCompletedFiles = new BooleanParameter(cSection, "Prioritize Most Completed Files", "ConfigView.label.prioritizemostcompletedfiles");
            mostCompletedFiles.setLayoutData(gridData);
            Composite cMiniArea = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cMiniArea.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            cMiniArea.setLayoutData((Object)gridData);
            gridData = new GridData();
            label = new Label(cMiniArea, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.transfer.ignorepeerports");
            gridData = new GridData();
            gridData.widthHint = 125;
            StringParameter ignore_ports = new StringParameter(cMiniArea, "Ignore.peer.ports", "0");
            ignore_ports.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter pauseOnExit = new BooleanParameter(cSection, "Pause Downloads On Exit", "ConfigView.label.pause.downloads.on.exit");
            pauseOnExit.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter resumeOnStart = new BooleanParameter(cSection, "Resume Downloads On Start", "ConfigView.label.resume.downloads.on.start");
            resumeOnStart.setLayoutData(gridData);
        }
        return cSection;
    }
}

