/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.peer;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class PeerInfoView
extends AbstractIView
implements ObfusticateImage {
    private static final int BLOCK_FILLSIZE = 14;
    private static final int BLOCK_SPACING = 2;
    private static final int BLOCK_SIZE = 16;
    private static final int BLOCKCOLOR_AVAIL_HAVE = 0;
    private static final int BLOCKCOLOR_AVAIL_NOHAVE = 1;
    private static final int BLOCKCOLOR_NOAVAIL_HAVE = 2;
    private static final int BLOCKCOLOR_NOAVAIL_NOHAVE = 3;
    private static final int BLOCKCOLOR_TRANSFER = 4;
    private static final int BLOCKCOLOR_NEXT = 5;
    private static final int BLOCKCOLOR_AVAILCOUNT = 6;
    private Composite peerInfoComposite;
    private ScrolledComposite sc;
    protected Canvas peerInfoCanvas;
    private Color[] blockColors;
    private Label topLabel;
    private Label imageLabel;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update") * 2;
    private int loopFactor = 0;
    private PEPeer peer;
    private Plugin countryLocator = null;
    private String sCountryImagesDir;
    private Font font = null;
    Image img = null;

    public PeerInfoView() {
        this.blockColors = new Color[]{Colors.blues[9], Colors.blues[2], Colors.fadedGreen, Colors.white, Colors.red, Colors.fadedRed, Colors.black};
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PeerInfoView.this.initCountryPlugin();
            }
        });
    }

    private void initCountryPlugin() {
        try {
            PluginInterface pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID("CountryLocator");
            if (pi != null) {
                this.countryLocator = pi.getPlugin();
                if (!pi.getPluginState().isOperational() || pi.getUtilities().compareVersions(pi.getPluginVersion(), "1.6") < 0) {
                    this.countryLocator = null;
                }
                if (this.countryLocator != null) {
                    this.sCountryImagesDir = (String)this.countryLocator.getClass().getMethod("getImageLocation", Integer.TYPE).invoke((Object)this.countryLocator, new Integer(0));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        this.peer = newDataSource == null ? null : (newDataSource instanceof Object[] ? (PEPeer)((Object[])newDataSource)[0] : (PEPeer)newDataSource);
        this.fillPeerInfoSection();
    }

    public String getData() {
        return "PeersView.BlockView.title";
    }

    public void initialize(Composite composite) {
        if (this.peerInfoComposite != null && !this.peerInfoComposite.isDisposed()) {
            Logger.log(new LogEvent(LogIDs.GUI, 3, "PeerInfoView already initialized! Stack: " + Debug.getStackTrace(true, false)));
            this.delete();
        }
        this.createPeerInfoPanel(composite);
    }

    private Composite createPeerInfoPanel(Composite parent) {
        this.peerInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.peerInfoComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        this.peerInfoComposite.setLayoutData((Object)gridData);
        this.imageLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData();
        if (this.countryLocator != null) {
            gridData.widthHint = 28;
        }
        this.imageLabel.setLayoutData((Object)gridData);
        this.topLabel = new Label(this.peerInfoComposite, 0);
        gridData = new GridData(4, -1, false, false);
        this.topLabel.setLayoutData((Object)gridData);
        this.sc = new ScrolledComposite(this.peerInfoComposite, 512);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.sc.setLayout((Layout)layout);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.sc.setLayoutData((Object)gridData);
        this.sc.getVerticalBar().setIncrement(16);
        this.peerInfoCanvas = new Canvas((Composite)this.sc, 0x140000);
        gridData = new GridData(4, -1, true, false);
        this.peerInfoCanvas.setLayoutData((Object)gridData);
        this.peerInfoCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (e.width <= 0 || e.height <= 0) {
                    return;
                }
                try {
                    Rectangle bounds;
                    Rectangle rectangle = bounds = PeerInfoView.this.img == null ? null : PeerInfoView.this.img.getBounds();
                    if (bounds == null) {
                        e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    } else {
                        if (e.x + e.width > bounds.width) {
                            e.gc.fillRectangle(bounds.width, e.y, e.x + e.width - bounds.width + 1, e.height);
                        }
                        if (e.y + e.height > bounds.height) {
                            e.gc.fillRectangle(e.x, bounds.height, e.width, e.y + e.height - bounds.height + 1);
                        }
                        int width = Math.min(e.width, bounds.width - e.x);
                        int height = Math.min(e.height, bounds.height - e.y);
                        e.gc.drawImage(PeerInfoView.this.img, e.x, e.y, width, height, e.x, e.y, width, height);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Listener doNothingListener = new Listener(){

            public void handleEvent(Event event2) {
            }
        };
        this.peerInfoCanvas.addListener(1, doNothingListener);
        this.peerInfoCanvas.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                e.widget.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        int iNewColCount;
                        int iOldColCount;
                        if (PeerInfoView.this.img != null && (iOldColCount = PeerInfoView.this.img.getBounds().width / 16) != (iNewColCount = PeerInfoView.this.peerInfoCanvas.getClientArea().width / 16)) {
                            PeerInfoView.this.refreshInfoCanvas();
                        }
                    }
                });
            }
        });
        this.sc.setContent((Control)this.peerInfoCanvas);
        Legend.createLegendComposite(this.peerInfoComposite, this.blockColors, new String[]{"PeersView.BlockView.Avail.Have", "PeersView.BlockView.Avail.NoHave", "PeersView.BlockView.NoAvail.Have", "PeersView.BlockView.NoAvail.NoHave", "PeersView.BlockView.Transfer", "PeersView.BlockView.NextRequest", "PeersView.BlockView.AvailCount"}, new GridData(4, -1, true, false, 2, 1));
        int iFontPixelsHeight = 10;
        int iFontPointHeight = iFontPixelsHeight * 72 / this.peerInfoCanvas.getDisplay().getDPI().y;
        Font f = this.peerInfoCanvas.getFont();
        FontData[] fontData = f.getFontData();
        fontData[0].setHeight(iFontPointHeight);
        this.font = new Font((Device)this.peerInfoCanvas.getDisplay(), fontData);
        return this.peerInfoComposite;
    }

    public void fillPeerInfoSection() {
        if (this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.peer == null) {
            this.topLabel.setText("");
        } else {
            String s = this.peer.getClient();
            if (s == null) {
                s = "";
            }
            if (s != "") {
                s = s + "; ";
            }
            s = s + this.peer.getIp() + "; " + DisplayFormatters.formatPercentFromThousands(this.peer.getPercentDoneInThousandNotation());
            this.topLabel.setText(s);
            if (this.countryLocator != null) {
                try {
                    String sCountry = (String)this.countryLocator.getClass().getMethod("getIPCountry", String.class, Locale.class).invoke((Object)this.countryLocator, this.peer.getIp(), Locale.getDefault());
                    String sCode = (String)this.countryLocator.getClass().getMethod("getIPISO3166", String.class).invoke((Object)this.countryLocator, this.peer.getIp());
                    this.imageLabel.setToolTipText(sCode + "- " + sCountry);
                    InputStream is = this.countryLocator.getClass().getClassLoader().getResourceAsStream(this.sCountryImagesDir + "/" + sCode.toLowerCase() + ".png");
                    if (is != null) {
                        Image img = new Image((Device)this.imageLabel.getDisplay(), is);
                        img.setBackground(this.imageLabel.getBackground());
                        this.imageLabel.setImage(img);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.refreshInfoCanvas();
    }

    public void refresh() {
        super.refresh();
        if (this.loopFactor++ % this.graphicsUpdate == 0) {
            this.refreshInfoCanvas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshInfoCanvas() {
        this.peerInfoCanvas.layout(true);
        Rectangle bounds = this.peerInfoCanvas.getClientArea();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        if (this.peer == null || this.peer.getPeerState() != 30) {
            GC gc = new GC((Drawable)this.peerInfoCanvas);
            gc.fillRectangle(bounds);
            gc.dispose();
            return;
        }
        BitFlags peerHavePieces = this.peer.getAvailable();
        if (peerHavePieces == null) {
            GC gc = new GC((Drawable)this.peerInfoCanvas);
            gc.fillRectangle(bounds);
            gc.dispose();
            return;
        }
        DiskManagerPiece[] dm_pieces = null;
        PEPeerManager pm = this.peer.getManager();
        DiskManager dm = pm.getDiskManager();
        dm_pieces = dm.getPieces();
        int iNumCols = bounds.width / 16;
        int iNeededHeight = ((dm.getNbPieces() - 1) / iNumCols + 1) * 16;
        if (this.sc.getMinHeight() != iNeededHeight) {
            this.sc.setMinHeight(iNeededHeight);
            this.sc.layout(true, true);
            bounds = this.peerInfoCanvas.getClientArea();
        }
        this.img = new Image((Device)this.peerInfoCanvas.getDisplay(), bounds.width, iNeededHeight);
        GC gcImg = new GC((Drawable)this.img);
        try {
            int[] peerRequestedPieces;
            gcImg.setAdvanced(true);
            gcImg.setBackground(this.peerInfoCanvas.getBackground());
            gcImg.fillRectangle(0, 0, bounds.width, iNeededHeight);
            int[] availability = pm.getAvailability();
            int iNextDLPieceID = -1;
            int iDLPieceID = -1;
            int[] ourRequestedPieces = this.peer.getOutgoingRequestedPieceNumbers();
            if (ourRequestedPieces != null) {
                if (!this.peer.isChokingMe()) {
                    if (ourRequestedPieces.length > 0) {
                        iDLPieceID = ourRequestedPieces[0];
                        if (ourRequestedPieces.length > 1) {
                            iNextDLPieceID = ourRequestedPieces[1];
                        }
                    }
                } else if (ourRequestedPieces.length > 0) {
                    iNextDLPieceID = ourRequestedPieces[0];
                }
            }
            if ((peerRequestedPieces = this.peer.getIncomingRequestedPieceNumbers()) == null) {
                peerRequestedPieces = new int[]{};
            }
            int peerNextRequestedPiece = -1;
            if (peerRequestedPieces.length > 0) {
                peerNextRequestedPiece = peerRequestedPieces[0];
            }
            Arrays.sort(peerRequestedPieces);
            int iRow = 0;
            int iCol = 0;
            for (int i = 0; i < peerHavePieces.flags.length; ++i) {
                int colorIndex;
                boolean done = dm_pieces == null ? false : dm_pieces[i].isDone();
                int iXPos = iCol * 16;
                int iYPos = iRow * 16;
                if (done) {
                    colorIndex = peerHavePieces.flags[i] ? 0 : 2;
                    gcImg.setBackground(this.blockColors[colorIndex]);
                    gcImg.fillRectangle(iXPos, iYPos, 14, 14);
                } else {
                    boolean partiallyDone = dm_pieces == null ? false : dm_pieces[i].getNbWritten() > 0;
                    int x = iXPos;
                    int width = 14;
                    if (partiallyDone) {
                        colorIndex = peerHavePieces.flags[i] ? 0 : 2;
                        gcImg.setBackground(this.blockColors[colorIndex]);
                        int iNewWidth = (int)((float)dm_pieces[i].getNbWritten() / (float)dm_pieces[i].getNbBlocks() * (float)width);
                        if (iNewWidth >= width) {
                            iNewWidth = width - 1;
                        } else if (iNewWidth <= 0) {
                            iNewWidth = 1;
                        }
                        gcImg.fillRectangle(x, iYPos, iNewWidth, 14);
                        width -= iNewWidth;
                        x += iNewWidth;
                    }
                    colorIndex = peerHavePieces.flags[i] ? 1 : 3;
                    gcImg.setBackground(this.blockColors[colorIndex]);
                    gcImg.fillRectangle(x, iYPos, width, 14);
                }
                if (i == iDLPieceID) {
                    gcImg.setBackground(this.blockColors[4]);
                    gcImg.fillPolygon(new int[]{iXPos, iYPos, iXPos + 14, iYPos, iXPos + 7, iYPos + 14});
                }
                if (i == iNextDLPieceID) {
                    gcImg.setBackground(this.blockColors[5]);
                    gcImg.fillPolygon(new int[]{iXPos + 2, iYPos + 2, iXPos + 14 - 1, iYPos + 2, iXPos + 7, iYPos + 14 - 1});
                }
                if (i == peerNextRequestedPiece) {
                    gcImg.setBackground(this.blockColors[4]);
                    gcImg.fillPolygon(new int[]{iXPos, iYPos + 14, iXPos + 14, iYPos + 14, iXPos + 7, iYPos});
                } else if (Arrays.binarySearch(peerRequestedPieces, i) >= 0) {
                    gcImg.setBackground(this.blockColors[5]);
                    gcImg.fillPolygon(new int[]{iXPos + 1, iYPos + 14 - 2, iXPos + 14 - 2, iYPos + 14 - 2, iXPos + 7, iYPos + 2});
                }
                if (availability != null) {
                    gcImg.setFont(this.font);
                    String sNumber = String.valueOf(availability[i]);
                    Point size = gcImg.stringExtent(sNumber);
                    if (availability[i] < 100) {
                        int x = iXPos + 7 - size.x / 2;
                        int y = iYPos + 7 - size.y / 2;
                        gcImg.setForeground(this.blockColors[6]);
                        gcImg.drawText(sNumber, x, y, true);
                    }
                }
                if (++iCol < iNumCols) continue;
                iCol = 0;
                ++iRow;
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LogIDs.GUI, "drawing piece map", e));
        }
        finally {
            gcImg.dispose();
        }
        this.peerInfoCanvas.redraw();
    }

    public Composite getComposite() {
        return this.peerInfoComposite;
    }

    public void delete() {
        if (!this.imageLabel.isDisposed() && this.imageLabel.getImage() != null) {
            Image image = this.imageLabel.getImage();
            this.imageLabel.setImage(null);
            image.dispose();
        }
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
            this.img = null;
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
            this.font = null;
        }
        super.delete();
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        UIDebugGenerator.obfusticateArea(image, (Control)this.topLabel, shellOffset, "");
        return image;
    }
}

