/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnSortObject;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem1;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem2;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItemImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;

public class TableCellImpl
implements TableCellSWT {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final byte FLAG_VALID = 1;
    private static final byte FLAG_SORTVALUEISTEXT = 2;
    private static final byte FLAG_TOOLTIPISAUTO = 4;
    private static final byte FLAG_UPTODATE = 8;
    private static final byte FLAG_DISPOSED = 16;
    private static final byte FLAG_MUSTREFRESH = 32;
    private static final byte FLAG_VISUALLY_CHANGED_SINCE_REFRESH = 64;
    private byte flags;
    private TableRowCore tableRow;
    private Comparable sortValue;
    private BufferedTableItem bufferedTableItem;
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private ArrayList cellMouseListeners;
    private ArrayList cellMouseMoveListeners;
    private ArrayList cellVisibilityListeners;
    private ArrayList cellSWTPaintListeners;
    private TableColumnCore tableColumn;
    private byte refreshErrLoopCount;
    private byte tooltipErrLoopCount;
    private byte loopFactor;
    private Object oToolTip;
    private Object defaultToolTip;
    private int iCursorID = -1;
    private Graphic graphic = null;
    private ArrayList childCells;
    public boolean bDebug = false;
    private static AEMonitor this_mon = new AEMonitor("TableCell");
    private static final String CFG_PAINT = "GUI_SWT_bAlternateTablePainting";
    private static boolean bAlternateTablePainting;
    private static int MAX_REFRESHES;
    private static int MAX_REFRESHES_WITHIN_MS;
    private boolean bInRefresh = false;
    private long lastRefresh;
    private int numFastRefreshes;
    private byte restartRefresh = 0;
    private boolean bInRefreshAsync = false;
    private int textAlpha = 255;
    public static final Comparator TEXT_COMPARATOR;

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, int position, BufferedTableItem item) {
        this.tableColumn = _tableColumn;
        this.tableRow = _tableRow;
        this.flags = (byte)2;
        this.refreshErrLoopCount = 0;
        this.tooltipErrLoopCount = 0;
        this.loopFactor = 0;
        if (item != null) {
            this.bufferedTableItem = item;
        } else {
            this.createBufferedTableItem(position);
        }
        this.tableColumn.invokeCellAddedListeners(this);
    }

    public TableCellImpl(TableRowSWT _tableRow, TableColumnCore _tableColumn, int position) {
        this(_tableRow, _tableColumn, position, null);
    }

    private void createBufferedTableItem(int position) {
        BufferedTableRow bufRow = (BufferedTableRow)((Object)this.tableRow);
        if (this.tableColumn.getType() == 2) {
            this.bufferedTableItem = bAlternateTablePainting ? new BufferedGraphicTableItem2(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.clearFlag(1);
                    this.redraw();
                }
            } : new BufferedGraphicTableItem1(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.clearFlag(1);
                    this.redraw();
                }
            };
            this.setOrientationViaColumn();
        } else {
            this.bufferedTableItem = new BufferedTableItemImpl(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.clearFlag(1);
                }
            };
        }
    }

    private void pluginError(Throwable e) {
        String sTitleLanguageKey = this.tableColumn.getTitleLanguageKey();
        String sPosition = this.bufferedTableItem == null ? "null" : "" + this.bufferedTableItem.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")";
        Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
    }

    private void pluginError(String s) {
        String sTitleLanguageKey = this.tableColumn.getTitleLanguageKey();
        String sPosition = "r" + this.tableRow.getIndex() + (this.bufferedTableItem == null ? "null" : "c" + this.bufferedTableItem.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")");
        Logger.log(new LogEvent(LOGID, 3, "Table Cell Plugin for Column #" + sPosition + ":" + s + "\n  " + Debug.getStackTrace(true, true)));
    }

    private void checkCellForSetting() {
        if (this.isDisposed()) {
            throw new UIRuntimeException("Table Cell is disposed.");
        }
    }

    public Object getDataSource() {
        TableRowCore row = this.tableRow;
        TableColumnCore col = this.tableColumn;
        if (row == null || col == null) {
            return null;
        }
        return row.getDataSource(col.getUseCoreDataSource());
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    public TableRow getTableRow() {
        return this.tableRow;
    }

    public String getTableID() {
        return this.tableRow.getTableID();
    }

    public boolean isValid() {
        return (this.flags & 1) != 0;
    }

    public Color getForegroundSWT() {
        this.checkCellForSetting();
        return this.bufferedTableItem.getForeground();
    }

    public Color getBackgroundSWT() {
        this.checkCellForSetting();
        return this.bufferedTableItem.getBackground();
    }

    public int[] getBackground() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        Color color = this.bufferedTableItem.getBackground();
        if (color == null) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public int[] getForeground() {
        if (this.bufferedTableItem == null) {
            return new int[]{0, 0, 0};
        }
        Color color = this.bufferedTableItem.getForeground();
        if (color == null) {
            return new int[3];
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public boolean setForeground(Color color) {
        this.checkCellForSetting();
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        boolean set = this.bufferedTableItem.setForeground(color);
        if (set) {
            this.setFlag(64);
        }
        return set;
    }

    public boolean setForeground(int red, int green, int blue) {
        this.checkCellForSetting();
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        boolean set = red < 0 || green < 0 || blue < 0 ? this.bufferedTableItem.setForeground(null) : this.bufferedTableItem.setForeground(red, green, blue);
        if (set) {
            this.setFlag(64);
        }
        return set;
    }

    public boolean setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            return this.setForeground((Color)null);
        }
        return this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    public boolean setForegroundToErrorColor() {
        return this.setForeground(Colors.colorError);
    }

    public boolean setText(String text) {
        boolean do_auto;
        this.checkCellForSetting();
        if (text == null) {
            text = "";
        }
        boolean bChanged = false;
        if (this.hasFlag(2) && !text.equals(this.sortValue)) {
            bChanged = true;
            this.sortValue = text;
            this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
            if (this.bDebug) {
                this.debug("Setting SortValue to text;");
            }
        }
        if (this.bufferedTableItem.setText(text) && !this.hasFlag(2)) {
            bChanged = true;
        }
        if (this.bDebug) {
            this.debug("setText (" + bChanged + ") : " + text);
        }
        if (bChanged) {
            this.setFlag(64);
        }
        if (!(do_auto = this.tableColumn.doesAutoTooltip())) {
            if (this.hasFlag(4)) {
                this.oToolTip = null;
                this.clearFlag(4);
            }
        } else {
            this.oToolTip = text;
            this.setFlag(4);
        }
        return bChanged;
    }

    private boolean isInvisibleAndCanRefresh() {
        return !this.isShown() && (this.refreshListeners != null || this.tableColumn.hasCellRefreshListener());
    }

    public String getText() {
        if (this.hasFlag(2) && this.sortValue instanceof String) {
            return (String)((Object)this.sortValue);
        }
        if (this.bufferedTableItem == null) {
            return null;
        }
        return this.bufferedTableItem.getText();
    }

    public boolean isShown() {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.isShown() && this.tableRow.getView().isColumnVisible(this.tableColumn);
    }

    public boolean setSortValue(Comparable valueToSort) {
        if (!(this.tableColumn.isSortValueLive() || valueToSort instanceof Number || valueToSort instanceof String || valueToSort instanceof TableColumnSortObject)) {
            this.tableColumn.setSortValueLive(true);
        }
        return this._setSortValue(valueToSort);
    }

    private boolean _setSortValue(Comparable valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (this.hasFlag(2)) {
            this.clearFlag(2);
            if (this.sortValue instanceof String) {
                this.setText((String)((Object)this.sortValue));
            }
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (valueToSort instanceof Number && this.sortValue instanceof Number && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (this.bDebug) {
            this.debug("Setting SortValue to " + (valueToSort == null ? "null" : valueToSort.getClass().getName()));
        }
        this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        this.sortValue = valueToSort;
        if (this.cellSWTPaintListeners != null || this.tableColumn.hasCellOtherListeners("SWTPaint")) {
            this.redraw();
        }
        return true;
    }

    public boolean setSortValue(long valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(new Long(valueToSort));
    }

    public boolean setSortValue(float valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        return this._setSortValue(new Float(valueToSort));
    }

    public Comparable getSortValue() {
        if (this.bDebug) {
            this.debug("GetSortValue;" + (this.sortValue == null ? "null" : this.sortValue.getClass().getName() + ";" + this.sortValue.toString()));
        }
        if (this.sortValue == null) {
            if (this.bufferedTableItem != null) {
                return this.bufferedTableItem.getText();
            }
            return "";
        }
        return this.sortValue;
    }

    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
        this.clearFlag(4);
    }

    public Object getToolTip() {
        return this.oToolTip;
    }

    public Object getDefaultToolTip() {
        return this.defaultToolTip;
    }

    public void setDefaultToolTip(Object tt) {
        this.defaultToolTip = tt;
    }

    public boolean isDisposed() {
        return this.hasFlag(16);
    }

    public int getMaxLines() {
        if (this.bufferedTableItem == null) {
            return 1;
        }
        return this.bufferedTableItem.getMaxLines();
    }

    public Point getSize() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
    }

    public int getWidth() {
        Point pt = null;
        if (this.bufferedTableItem instanceof BufferedGraphicTableItem) {
            pt = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
        } else {
            Rectangle bounds = this.bufferedTableItem.getBounds();
            if (bounds != null) {
                pt = new Point(bounds.width, bounds.height);
            }
        }
        if (pt == null) {
            return -1;
        }
        return pt.x;
    }

    public int getHeight() {
        Point pt = null;
        if (this.bufferedTableItem instanceof BufferedGraphicTableItem) {
            pt = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
        } else {
            Rectangle bounds = this.bufferedTableItem.getBounds();
            if (bounds != null) {
                pt = new Point(bounds.width, bounds.height);
            }
        }
        if (pt == null) {
            return -1;
        }
        return pt.y;
    }

    public boolean setGraphic(Image img) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        this.graphic = null;
        boolean b = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(img);
        if (b) {
            this.setFlag(64);
            this.bufferedTableItem.redraw();
        }
        return b;
    }

    public boolean setGraphic(Graphic img) {
        Image imgSWT;
        boolean b;
        boolean b2;
        if (img != null) {
            this.checkCellForSetting();
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        if (img == this.graphic && this.numFastRefreshes >= MAX_REFRESHES) {
            this.pluginError("TableCellImpl::setGraphic to same Graphic object. Forcing refresh.");
        }
        this.graphic = img;
        if (img == null && (b2 = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(null))) {
            this.setFlag(64);
            this.bufferedTableItem.redraw();
        }
        if (img instanceof GraphicSWT) {
            Image imgSWT2 = ((GraphicSWT)img).getImage();
            boolean b3 = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(imgSWT2);
            if (b3) {
                this.setFlag(64);
                this.bufferedTableItem.redraw();
            }
        } else if (img instanceof UISWTGraphic && (b = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(imgSWT = ((UISWTGraphic)img).getImage()))) {
            this.setFlag(64);
            this.bufferedTableItem.redraw();
        }
        return false;
    }

    public Graphic getGraphic() {
        if (this.graphic != null) {
            return this.graphic;
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        Image img = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getGraphic();
        return new UISWTGraphicImpl(img);
    }

    public Image getGraphicSWT() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getGraphic();
    }

    public void setFillCell(boolean bFillCell) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        if (bFillCell) {
            ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setOrientation(4);
        } else {
            this.setOrientationViaColumn();
        }
        this.setFlag(64);
    }

    public void setMarginHeight(int height) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(-1, height);
        this.setFlag(64);
    }

    public void setMarginWidth(int width) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(width, -1);
        this.setFlag(64);
    }

    public int getMarginHeight() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return 0;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getMarginHeight();
    }

    public int getMarginWidth() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return 0;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getMarginWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            if (this.bDebug) {
                this.debug("addRefreshListener; count=" + this.refreshListeners.size());
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                this.cellMouseMoveListeners = new ArrayList(1);
            }
            this.cellMouseMoveListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseMoveListener(TableCellMouseMoveListener listener) {
        try {
            this_mon.enter();
            if (this.cellMouseMoveListeners == null) {
                return;
            }
            this.cellMouseMoveListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSWTPaintListener(TableCellSWTPaintListener listener) {
        try {
            this_mon.enter();
            if (this.cellSWTPaintListeners == null) {
                this.cellSWTPaintListeners = new ArrayList(1);
            }
            this.cellSWTPaintListeners.add(listener);
        }
        finally {
            this_mon.exit();
        }
    }

    public void invokeSWTPaintListeners(GC gc) {
        Object[] swtPaintListeners;
        if (this.tableColumn != null && (swtPaintListeners = this.tableColumn.getCellOtherListeners("SWTPaint")) != null) {
            for (int i = 0; i < swtPaintListeners.length; ++i) {
                try {
                    TableCellSWTPaintListener l = (TableCellSWTPaintListener)swtPaintListeners[i];
                    l.cellPaint(gc, this);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        if (this.cellSWTPaintListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellSWTPaintListeners.size(); ++i) {
            try {
                TableCellSWTPaintListener l = (TableCellSWTPaintListener)this.cellSWTPaintListeners.get(i);
                l.cellPaint(gc, this);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseMoveListener) {
            this.addMouseMoveListener((TableCellMouseMoveListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
        if (listenerObject instanceof TableCellSWTPaintListener) {
            this.addSWTPaintListener((TableCellSWTPaintListener)listenerObject);
        }
    }

    public void invalidate() {
        this.checkCellForSetting();
        this.invalidate(true);
    }

    public void redraw() {
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.redraw();
        }
    }

    public void invalidate(boolean bMustRefresh) {
        if (!this.hasFlag(1)) {
            if (bMustRefresh) {
                if (this.hasFlag(32)) {
                    return;
                }
            } else {
                return;
            }
        }
        this.clearFlag(1);
        this.setFlag(64);
        if (this.bDebug) {
            this.debug("Invalidate Cell;" + bMustRefresh);
        }
        if (bMustRefresh) {
            this.setFlag(32);
            if (this.bufferedTableItem != null) {
                this.bufferedTableItem.invalidate();
            }
        }
    }

    public boolean refresh() {
        return this.refresh(true);
    }

    public void refreshAsync() {
        if (this.bInRefreshAsync) {
            if (this.restartRefresh < 127) {
                this.restartRefresh = (byte)(this.restartRefresh + 1);
            }
            return;
        }
        this.bInRefreshAsync = true;
        AERunnable runnable = new AERunnable(){

            public void runSupport() {
                TableCellImpl.this.restartRefresh = (byte)0;
                TableCellImpl.this.refresh(true);
                TableCellImpl.this.bInRefreshAsync = false;
                if (TableCellImpl.this.restartRefresh > 0) {
                    TableCellImpl.this.refreshAsync();
                }
            }
        };
        Utils.execSWTThreadLater(25, runnable);
    }

    public boolean refresh(boolean bDoGraphics) {
        boolean isRowShown;
        if (this.tableRow != null) {
            TableView view = this.tableRow.getView();
            isRowShown = view.isRowVisible(this.tableRow);
        } else {
            isRowShown = true;
        }
        boolean isCellShown = isRowShown && this.isShown();
        return this.refresh(bDoGraphics, isRowShown, isCellShown);
    }

    public boolean refresh(boolean bDoGraphics, boolean bRowVisible) {
        boolean isCellShown = bRowVisible && this.isShown();
        return this.refresh(bDoGraphics, bRowVisible, isCellShown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible, boolean bCellVisible) {
        if (this.tableColumn == null) {
            return false;
        }
        boolean ret = this.getVisuallyChangedSinceRefresh();
        this.clearFlag(64);
        int iErrCount = 0;
        if (this.refreshErrLoopCount > 2) {
            return ret;
        }
        iErrCount = this.tableColumn.getConsecutiveErrCount();
        if (iErrCount > 10) {
            this.refreshErrLoopCount = (byte)3;
            return ret;
        }
        if (this.bInRefresh) {
            if (this.bDebug) {
                this.debug("Calling Refresh from Refresh :) Skipping.");
            }
            return ret;
        }
        try {
            int iInterval;
            this.bInRefresh = true;
            if (ret) {
                long now = SystemTime.getCurrentTime();
                if (now - this.lastRefresh < (long)MAX_REFRESHES_WITHIN_MS) {
                    ++this.numFastRefreshes;
                    if (this.numFastRefreshes >= MAX_REFRESHES) {
                        if (this.numFastRefreshes % MAX_REFRESHES == 0) {
                            this.pluginError("this plugin is crazy. tried to refresh " + this.numFastRefreshes + " times in " + (now - this.lastRefresh) + "ms");
                        }
                        boolean bl = ret;
                        return bl;
                    }
                } else {
                    this.numFastRefreshes = 0;
                    this.lastRefresh = now;
                }
            }
            if (bCellVisible && !this.isUpToDate()) {
                if (this.bDebug) {
                    this.debug("Setting Invalid because visible & not up to date");
                }
                this.clearFlag(1);
                this.setFlag(8);
            } else if (!bCellVisible && this.isUpToDate()) {
                if (this.bDebug) {
                    this.debug("Setting not up to date because cell not visible " + Debug.getCompressedStackTrace());
                }
                this.clearFlag(8);
            }
            if (this.bDebug) {
                this.debug("Cell Valid?" + this.hasFlag(1) + "; Visible?" + this.tableRow.isVisible() + "/" + this.bufferedTableItem.isShown());
            }
            if ((iInterval = this.tableColumn.getRefreshInterval()) == -3 && !this.hasFlag(33) && this.hasFlag(2) && this.sortValue != null && this.tableColumn.getType() == 3) {
                if (bCellVisible) {
                    if (this.bDebug) {
                        this.debug("fast refresh: setText");
                    }
                    ret = this.setText((String)((Object)this.sortValue));
                    this.setFlag(1);
                }
            } else if (iInterval == -2 || iInterval == -1 && bDoGraphics || iInterval > 0 && this.loopFactor % iInterval == 0 || !this.hasFlag(1) || this.hasFlag(32)) {
                boolean bWasValid = this.isValid();
                if (this.hasFlag(32)) {
                    this.clearFlag(32);
                }
                if (this.bDebug) {
                    this.debug("invoke refresh; wasValid? " + bWasValid);
                }
                long lTimeStart = SystemTime.getMonotonousTime();
                this.tableColumn.invokeCellRefreshListeners(this, !bCellVisible);
                if (this.refreshListeners != null) {
                    for (int i = 0; i < this.refreshListeners.size(); ++i) {
                        TableCellRefreshListener l = (TableCellRefreshListener)this.refreshListeners.get(i);
                        if (l instanceof TableCellLightRefreshListener) {
                            ((TableCellLightRefreshListener)l).refresh(this, !bCellVisible);
                            continue;
                        }
                        l.refresh(this);
                    }
                }
                long lTimeEnd = SystemTime.getMonotonousTime();
                this.tableColumn.addRefreshTime(lTimeEnd - lTimeStart);
                if (!bWasValid && !this.hasFlag(32)) {
                    this.setFlag(1);
                }
            }
            this.loopFactor = (byte)(this.loopFactor + 1);
            this.refreshErrLoopCount = 0;
            if (iErrCount > 0) {
                this.tableColumn.setConsecutiveErrCount(0);
            }
            ret = this.getVisuallyChangedSinceRefresh();
            if (this.bDebug) {
                this.debug("refresh done; visual change? " + ret + ";" + Debug.getCompressedStackTrace());
            }
        }
        catch (Throwable e) {
            this.refreshErrLoopCount = (byte)(this.refreshErrLoopCount + 1);
            if (this.tableColumn != null) {
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
            }
            this.pluginError(e);
            if (this.refreshErrLoopCount > 2) {
                Logger.log(new LogEvent(LOGID, 3, "TableCell will not be refreshed anymore this session."));
            }
        }
        finally {
            this.bInRefresh = false;
        }
        if (this.childCells != null) {
            Object[] childCellsArray = this.childCells.toArray();
            for (int i = 0; i < childCellsArray.length; ++i) {
                TableCellImpl childCell = (TableCellImpl)childCellsArray[i];
                childCell.refresh(bDoGraphics, bRowVisible, bCellVisible);
            }
        }
        return ret;
    }

    public boolean getVisuallyChangedSinceRefresh() {
        return this.hasFlag(64);
    }

    public void dispose() {
        this.setFlag(16);
        this.tableColumn.invokeCellDisposeListeners(this);
        if (this.disposeListeners != null) {
            try {
                for (TableCellDisposeListener listener : this.disposeListeners) {
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.setForeground(null);
            this.bufferedTableItem.dispose();
        }
        this.refreshListeners = null;
        this.bufferedTableItem = null;
        this.tableColumn = null;
        this.tableRow = null;
        this.sortValue = null;
    }

    public boolean setIcon(Image img) {
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        this.bufferedTableItem.setIcon(img);
        this.graphic = null;
        this.setFlag(64);
        return true;
    }

    public Image getIcon() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        return this.bufferedTableItem.getIcon();
    }

    public boolean needsPainting() {
        if (this.cellSWTPaintListeners != null || this.tableColumn.hasCellOtherListeners("SWTPaint")) {
            return true;
        }
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.needsPainting();
    }

    public void doPaint(GC gc) {
        if (this.bDebug) {
            this.debug("doPaint up2date:" + this.hasFlag(8) + ";v:" + this.hasFlag(1) + ";rl=" + this.refreshListeners);
        }
        this.invokeSWTPaintListeners(gc);
        this.bufferedTableItem.doPaint(gc);
        if (this.childCells != null) {
            Object[] childCellsArray = this.childCells.toArray();
            for (int i = 0; i < childCellsArray.length; ++i) {
                TableCellImpl childCell = (TableCellImpl)childCellsArray[i];
                childCell.doPaint(gc);
            }
        }
    }

    public void locationChanged() {
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.locationChanged();
        }
    }

    public TableRowCore getTableRowCore() {
        return this.tableRow;
    }

    public TableRowSWT getTableRowSWT() {
        if (this.tableRow instanceof TableRowSWT) {
            return (TableRowSWT)this.tableRow;
        }
        return null;
    }

    public String toString() {
        return "TableCell {" + this.tableColumn.getName() + "," + (this.tableRow == null ? "" : "r" + this.tableRow.getIndex()) + (this.bufferedTableItem == null ? "c?" : "c" + this.bufferedTableItem.getPosition()) + "," + this.getText() + "," + this.getSortValue() + "}";
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellImpl)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException e) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    public void invokeToolTipListeners(int type) {
        block9: {
            if (this.tableColumn == null) {
                return;
            }
            this.tableColumn.invokeCellToolTipListeners(this, type);
            if (this.tooltipListeners == null || this.tooltipErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                if (type == 0) {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                    }
                } else {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                    }
                }
                this.tooltipErrLoopCount = 0;
            }
            catch (Throwable e) {
                this.tooltipErrLoopCount = (byte)(this.tooltipErrLoopCount + 1);
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.tooltipErrLoopCount <= 2) break block9;
                Logger.log(new LogEvent(LOGID, 3, "TableCell's tooltip will not be refreshed anymore this session."));
            }
        }
    }

    public void invokeMouseListeners(TableCellMouseEvent event2) {
        ArrayList listeners;
        ArrayList arrayList = listeners = event2.eventType == 3 ? this.cellMouseMoveListeners : this.cellMouseListeners;
        if (listeners == null) {
            return;
        }
        if (event2.cell != null && event2.row == null) {
            event2.row = event2.cell.getTableRow();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)listeners.get(i);
                l.cellMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void invokeVisibilityListeners(int visibility, boolean invokeColumnListeners) {
        if (invokeColumnListeners) {
            this.tableColumn.invokeCellVisibilityListeners(this, visibility);
        }
        if (this.cellVisibilityListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellVisibilityListeners.size(); ++i) {
            try {
                TableCellVisibilityListener l = (TableCellVisibilityListener)this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setUpToDate(boolean upToDate) {
        if (this.bDebug) {
            this.debug("set up to date to " + upToDate);
        }
        if (upToDate) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
    }

    public boolean isUpToDate() {
        return this.hasFlag(8);
    }

    public void debug(final String s) {
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                System.out.println(SystemTime.getCurrentTime() + ": r" + TableCellImpl.this.tableRow.getIndex() + "c" + TableCellImpl.this.tableColumn.getPosition() + "r.v?" + (TableCellImpl.this.tableRow.isVisible() ? "Y" : "N") + ";" + s);
            }
        }, true);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = this.bufferedTableItem.getBounds();
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return bounds;
    }

    private void setOrientationViaColumn() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        int align = this.tableColumn.getAlignment();
        BufferedGraphicTableItem ti = (BufferedGraphicTableItem)((Object)this.bufferedTableItem);
        ti.setOrientation(TableColumnSWTUtils.convertColumnAlignmentToSWT(align));
    }

    public String getObfusticatedText() {
        if (this.tableColumn.isObfusticated()) {
            if (this.tableColumn instanceof ObfusticateCellText) {
                return ((ObfusticateCellText)((Object)this.tableColumn)).getObfusticatedText(this);
            }
            return "";
        }
        return null;
    }

    public Graphic getBackgroundGraphic() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        return new UISWTGraphicImpl(this.bufferedTableItem.getBackgroundImage());
    }

    public Image getBackgroundImage() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        return this.bufferedTableItem.getBackgroundImage();
    }

    public BufferedTableItem getBufferedTableItem() {
        return this.bufferedTableItem;
    }

    public int getCursorID() {
        return this.iCursorID;
    }

    public void setCursorID(int cursorID) {
        this.iCursorID = cursorID;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableCellImpl.this.isMouseOver()) {
                    TableCellImpl.this.bufferedTableItem.setCursor(TableCellImpl.this.iCursorID);
                }
            }
        });
    }

    public boolean isMouseOver() {
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.isMouseOver();
    }

    public int[] getMouseOffset() {
        int[] nArray;
        Point ofs = ((TableViewSWT)this.tableRow.getView()).getTableCellMouseOffset(this);
        if (ofs == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = ofs.x;
            nArray = nArray2;
            nArray2[1] = ofs.y;
        }
        return nArray;
    }

    private boolean hasFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    private void setFlag(int flag) {
        this.flags = (byte)(this.flags | flag);
    }

    private void clearFlag(int flag) {
        this.flags = (byte)(this.flags & ~flag);
    }

    public void addChildCell(TableCellImpl childCell) {
        if (this.childCells == null) {
            this.childCells = new ArrayList(1);
        }
        this.childCells.add(childCell);
    }

    public int getTextAlpha() {
        return this.textAlpha;
    }

    public void setTextAlpha(int textOpacity) {
        this.textAlpha = textOpacity;
    }

    static {
        MAX_REFRESHES = 10;
        MAX_REFRESHES_WITHIN_MS = 100;
        COConfigurationManager.addAndFireParameterListener(CFG_PAINT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bAlternateTablePainting = COConfigurationManager.getBooleanParameter(TableCellImpl.CFG_PAINT);
            }
        });
        TEXT_COMPARATOR = new TextComparator();
    }

    private static class TextComparator
    implements Comparator {
        private TextComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

