/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCoreCreationListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnManager {
    private static final String CONFIG_FILE = "tables.config";
    private static TableColumnManager instance;
    private static AEMonitor class_mon;
    private Map<String, Map> items;
    private AEMonitor items_mon = new AEMonitor("TableColumnManager:items");
    private Map autoHideOrder = new LightHashMap();
    private Map mapTablesConfig;
    private static Comparator orderComparator;
    private Map<String, TableColumnCreationListener> mapColumnIDsToListener = new LightHashMap<String, TableColumnCreationListener>();
    private Map<Class, List> mapDataSourceTypeToColumnIDs = new LightHashMap<Class, List>();

    private TableColumnManager() {
        this.items = new HashMap<String, Map>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableColumnManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableColumnManager();
            }
            TableColumnManager tableColumnManager = instance;
            return tableColumnManager;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addColumns(TableColumnCore[] itemsToAdd) {
        try {
            this.items_mon.enter();
            for (int i = 0; i < itemsToAdd.length; ++i) {
                TableColumnCore item = itemsToAdd[i];
                if (item.isRemoved()) continue;
                String name = item.getName();
                String sTableID = item.getTableID();
                LinkedHashMap<String, TableColumnCore> mTypes = this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableColumnCore>();
                    this.items.put(sTableID, mTypes);
                }
                if (!mTypes.containsKey(name)) {
                    mTypes.put(name, item);
                    Map mapColumnConfig = this.getTableConfigMap(sTableID);
                    item.loadSettings(mapColumnConfig);
                }
                if (item.getColumnAdded()) continue;
                item.setColumnAdded(true);
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Table Column Extension");
            Debug.printStackTrace(e);
        }
        finally {
            this.items_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeColumns(TableColumnCore[] itemsToRemove) {
        try {
            this.items_mon.enter();
            for (int i = 0; i < itemsToRemove.length; ++i) {
                TableColumnCore item = itemsToRemove[i];
                String name = item.getName();
                String sTableID = item.getTableID();
                Map mTypes = this.items.get(sTableID);
                if (mTypes != null && mTypes.remove(name) == null) continue;
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Table Column Extension");
            Debug.printStackTrace(e);
        }
        finally {
            this.items_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TableColumnCore> getTableColumnsAsMap(Class forDataSourceType, String sTableID) {
        try {
            this.items_mon.enter();
            LinkedHashMap<String, TableColumnCore> mReturn = new LinkedHashMap<String, TableColumnCore>();
            Map<String, TableColumnCore> mTypes = this.getAllTableColumnCore(forDataSourceType, sTableID);
            if (mTypes != null) {
                mReturn.putAll(mTypes);
            }
            LinkedHashMap<String, TableColumnCore> linkedHashMap = mReturn;
            return linkedHashMap;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public int getTableColumnCount(String sTableID) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return 0;
        }
        return mTypes.size();
    }

    public TableColumnCore[] getAllTableColumnCoreAsArray(Class forDataSourceType, String tableID) {
        Map<String, TableColumnCore> mTypes = this.getAllTableColumnCore(forDataSourceType, tableID);
        return mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TableColumnCore> getAllTableColumnCore(Class forDataSourceType, String tableID) {
        LinkedHashMap<String, TableColumnCore> mTypes = null;
        try {
            this.items_mon.enter();
            mTypes = this.items.get(tableID);
            if (mTypes == null) {
                mTypes = new LinkedHashMap<String, TableColumnCore>();
                this.items.put(tableID, mTypes);
            }
            if (forDataSourceType != null) {
                List listDST = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
                if (listDST != null) {
                    this.doAddCreate(mTypes, forDataSourceType, tableID, listDST);
                }
                if (forDataSourceType.equals(DownloadTypeComplete.class) || forDataSourceType.equals(DownloadTypeIncomplete.class)) {
                    listDST = this.mapDataSourceTypeToColumnIDs.get(Download.class);
                    if (listDST != null && listDST.size() > 0) {
                        this.doAddCreate(mTypes, Download.class, tableID, listDST);
                    }
                } else if (Download.class.equals((Object)forDataSourceType)) {
                    listDST = this.mapDataSourceTypeToColumnIDs.get(DownloadTypeComplete.class);
                    if (listDST != null && listDST.size() > 0) {
                        this.doAddCreate(mTypes, DownloadTypeComplete.class, tableID, listDST);
                    }
                    if ((listDST = this.mapDataSourceTypeToColumnIDs.get(DownloadTypeIncomplete.class)) != null && listDST.size() > 0) {
                        this.doAddCreate(mTypes, DownloadTypeIncomplete.class, tableID, listDST);
                    }
                }
            }
        }
        finally {
            this.items_mon.exit();
        }
        return mTypes;
    }

    private void doAddCreate(Map mTypes, Class forDataSourceType, String tableID, List listDST) {
        for (String columnID : listDST) {
            if (mTypes.containsKey(columnID)) continue;
            try {
                TableColumnCreationListener l = this.mapColumnIDsToListener.get(forDataSourceType + "." + columnID);
                TableColumnCore tc = null;
                if (l instanceof TableColumnCoreCreationListener) {
                    tc = ((TableColumnCoreCreationListener)l).createTableColumnCore(forDataSourceType, tableID, columnID);
                }
                if (tc == null) {
                    tc = new TableColumnImpl(forDataSourceType, tableID, columnID);
                }
                l.tableColumnCreated(tc);
                this.addColumns(new TableColumnCore[]{tc});
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableIDs() {
        try {
            this.items_mon.enter();
            Set<String> ids = this.items.keySet();
            String[] stringArray = ids.toArray(new String[ids.size()]);
            return stringArray;
        }
        finally {
            this.items_mon.exit();
        }
    }

    public String[] appendLists(String[] list1, String[] list2) {
        int size = list1.length + list2.length;
        String[] list = new String[size];
        System.arraycopy(list1, 0, list, 0, list1.length);
        System.arraycopy(list2, 0, list, list1.length, list2.length);
        return list;
    }

    public TableColumnCore getTableColumnCore(String sTableID, String sColumnName) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return null;
        }
        return (TableColumnCore)mTypes.get(sColumnName);
    }

    public void ensureIntegrety(String sTableID) {
        Map mTypes = this.items.get(sTableID);
        if (mTypes == null) {
            return;
        }
        TableColumnCore[] tableColumns = mTypes.values().toArray(new TableColumnCore[mTypes.values().size()]);
        Arrays.sort(tableColumns, TableColumnManager.getTableColumnOrderComparator());
        int iPos = 0;
        for (int i = 0; i < tableColumns.length; ++i) {
            int iCurPos = tableColumns[i].getPosition();
            if (iCurPos == -1) {
                tableColumns[i].setVisible(false);
                continue;
            }
            tableColumns[i].setPositionNoShift(iPos++);
        }
    }

    public String getDefaultSortColumnName(String tableID) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        Object object = mapTableConfig.get("SortColumn");
        if (object instanceof byte[]) {
            object = new String((byte[])object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        String s = COConfigurationManager.getStringParameter(tableID + ".sortColumn");
        if (s != null) {
            COConfigurationManager.removeParameter(tableID + ".sortColumn");
            COConfigurationManager.removeParameter(tableID + ".sortAsc");
        }
        return s;
    }

    public void setDefaultSortColumnName(String tableID, String columnName) {
        Map mapTableConfig = this.getTableConfigMap(tableID);
        mapTableConfig.put("SortColumn", columnName);
        this.saveTableConfigs();
    }

    private void saveTableConfigs() {
        if (this.mapTablesConfig != null) {
            FileUtil.writeResilientConfigFile(CONFIG_FILE, this.mapTablesConfig);
        }
    }

    public void saveTableColumns(Class forDataSourceType, String sTableID) {
        try {
            Map mapTableConfig = this.getTableConfigMap(sTableID);
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            for (int i = 0; i < tcs.length; ++i) {
                if (tcs[i] == null) continue;
                tcs[i].saveSettings(mapTableConfig);
            }
            this.saveTableConfigs();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public boolean loadTableColumnSettings(Class forDataSourceType, String sTableID) {
        try {
            Map mapTableConfig = this.getTableConfigMap(sTableID);
            int size = mapTableConfig.size();
            if (size == 0 || size == 1 && mapTableConfig.containsKey("SortColumn")) {
                return false;
            }
            TableColumnCore[] tcs = this.getAllTableColumnCoreAsArray(forDataSourceType, sTableID);
            for (int i = 0; i < tcs.length; ++i) {
                if (tcs[i] == null) continue;
                tcs[i].loadSettings(mapTableConfig);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTableConfigMap(String sTableID) {
        TableColumnManager tableColumnManager = this;
        synchronized (tableColumnManager) {
            HashMap mapTableConfig;
            if (this.mapTablesConfig == null) {
                this.mapTablesConfig = FileUtil.readResilientConfigFile(CONFIG_FILE);
                SimpleTimer.addEvent("DisposeTbaleConfigMap", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        2 var2_2 = this;
                        synchronized (var2_2) {
                            TableColumnManager.this.saveTableConfigs();
                            TableColumnManager.this.mapTablesConfig = null;
                        }
                    }
                });
            }
            if ((mapTableConfig = (HashMap)this.mapTablesConfig.get("Table." + sTableID)) == null) {
                mapTableConfig = new HashMap();
                this.mapTablesConfig.put("Table." + sTableID, mapTableConfig);
            }
            return mapTableConfig;
        }
    }

    public void setAutoHideOrder(String sTableID, String[] autoHideOrderColumnIDs) {
        ArrayList<TableColumnCore> autoHideOrderList = new ArrayList<TableColumnCore>(autoHideOrderColumnIDs.length);
        for (int i = 0; i < autoHideOrderColumnIDs.length; ++i) {
            String sColumnID = autoHideOrderColumnIDs[i];
            TableColumnCore column = this.getTableColumnCore(sTableID, sColumnID);
            if (column == null) continue;
            autoHideOrderList.add(column);
        }
        this.autoHideOrder.put(sTableID, autoHideOrderList);
    }

    public List getAutoHideOrder(String sTableID) {
        List list = (List)this.autoHideOrder.get(sTableID);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDiagnostics(IndentWriter writer) {
        try {
            this.items_mon.enter();
            writer.println("TableColumns");
            for (String sTableID : this.items.keySet()) {
                Map mTypes = this.items.get(sTableID);
                writer.indent();
                writer.println(sTableID + ": " + mTypes.size() + " columns:");
                writer.indent();
                for (TableColumnCore tc : mTypes.values()) {
                    tc.generateDiagnostics(writer);
                }
                writer.exdent();
                writer.exdent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.items_mon.exit();
        }
    }

    public static Comparator getTableColumnOrderComparator() {
        return orderComparator;
    }

    public void registerColumn(Class forDataSourceType, String columnID, TableColumnCreationListener listener) {
        this.mapColumnIDsToListener.put(forDataSourceType + "." + columnID, listener);
        ArrayList<String> list = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.mapDataSourceTypeToColumnIDs.put(forDataSourceType, list);
        }
        list.add(columnID);
    }

    public void unregisterColumn(Class forDataSourceType, String columnID, TableColumnCreationListener listener) {
        this.mapColumnIDsToListener.remove(forDataSourceType + "." + columnID);
        List list = this.mapDataSourceTypeToColumnIDs.get(forDataSourceType);
        if (list != null) {
            list.remove(columnID);
        }
    }

    public TableColumnInfo getColumnInfo(Class forDataSourceType, String forTableID, String columnID) {
        TableColumnCore column = this.getTableColumnCore(forTableID, columnID);
        TableColumnInfoImpl columnInfo = new TableColumnInfoImpl(column);
        List<TableColumnExtraInfoListener> listeners = column.getColumnExtraInfoListeners();
        for (TableColumnExtraInfoListener l : listeners) {
            l.fillTableColumnInfo(columnInfo);
        }
        if (columnInfo.getCategories() == null && !(column instanceof CoreTableColumn)) {
            columnInfo.addCategories(new String[]{"plugin"});
        }
        return columnInfo;
    }

    static {
        class_mon = new AEMonitor("TableColumnManager");
        orderComparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg1 instanceof TableColumn && arg0 instanceof TableColumn) {
                    int iPositionB;
                    int iPositionA = ((TableColumn)arg0).getPosition();
                    if (iPositionA < 0) {
                        iPositionA = 65535 + iPositionA;
                    }
                    if ((iPositionB = ((TableColumn)arg1).getPosition()) < 0) {
                        iPositionB = 65535 + iPositionB;
                    }
                    return iPositionA - iPositionB;
                }
                return 0;
            }
        };
    }
}

