/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class FileExtensionItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public FileExtensionItem() {
        super("fileext", 1, -1, 50, "Files");
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        cell.setText(FileExtensionItem.determineFileExt(fileInfo2));
    }

    private static String determineFileExt(DiskManagerFileInfo fileInfo2) {
        String name = fileInfo2 == null ? "" : fileInfo2.getFile(true).getName();
        int dot_position = name.lastIndexOf(".");
        if (dot_position == -1) {
            return "";
        }
        return name.substring(dot_position + 1);
    }
}

