/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PriorityItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PriorityItem() {
        super("priority", 1, -2, 70, "Files");
        this.setRefreshInterval(-2);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public void refresh(TableCell cell) {
        String tmp;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int sortval = 0;
        if (fileInfo2 == null) {
            tmp = "";
        } else if (fileInfo2.getStorageType() == 2 && fileInfo2.isSkipped()) {
            tmp = MessageText.getString("FileItem.delete");
            sortval = 1;
        } else if (fileInfo2.isSkipped()) {
            tmp = MessageText.getString("FileItem.donotdownload");
            sortval = 2;
        } else if (fileInfo2.isPriority()) {
            tmp = MessageText.getString("FileItem.high");
            sortval = 4;
        } else {
            tmp = MessageText.getString("FileItem.normal");
            sortval = 3;
        }
        cell.setText(tmp);
        cell.setSortValue(sortval);
    }
}

