/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.common.table.TableRowCore;
import java.io.File;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class DateAddedItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "date_added";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
    }

    public DateAddedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setMultiline(false);
        TableContextMenuItem menuReset = this.addContextMenuItem("TableColumn.menu.date_added.reset");
        menuReset.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof TableRowCore) {
                    TableRowCore row = (TableRowCore)target;
                    Object dataSource = row.getDataSource(true);
                    if (dataSource instanceof DownloadManager) {
                        DownloadManager dm = (DownloadManager)dataSource;
                        DownloadManagerState state = dm.getDownloadState();
                        try {
                            long add_time = new File(dm.getTorrentFileName()).lastModified();
                            if (add_time >= 0L) {
                                state.setLongParameter("stats.download.added.time", add_time);
                            }
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    row.getTableCell(DateAddedItem.COLUMN_ID).invalidate();
                }
            }
        });
    }

    public DateAddedItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    public void refresh(TableCell cell, long timestamp) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        timestamp = dm == null ? 0L : dm.getDownloadState().getLongParameter("stats.download.added.time");
        super.refresh(cell, timestamp);
    }
}

