/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class HealthItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    static final int COLUMN_WIDTH = 16;
    public static final String COLUMN_ID = "health";
    static TRHost tracker_host = null;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    public HealthItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 16, sTableID);
        this.initializeAsGraphic(-2, 16);
        this.setMinWidth(16);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        String sToolTip;
        TRHostTorrent ht;
        int health;
        DownloadManager dm;
        if (tracker_host == null) {
            try {
                tracker_host = AzureusCoreFactory.getSingleton().getTrackerHost();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (tracker_host == null) {
                return;
            }
        }
        if ((dm = (DownloadManager)cell.getDataSource()) == null) {
            health = 0;
            ht = null;
        } else {
            health = dm.getHealthStatus();
            ht = tracker_host.getHostTorrent(dm.getTorrent());
        }
        if (!cell.setSortValue(health + (ht == null ? 0 : 256)) && cell.isValid()) {
            return;
        }
        String sHelpID = null;
        if (health == 5) {
            sHelpID = "health.explain.red";
        } else if (health == 4) {
            sHelpID = "health.explain.green";
        } else if (health == 2) {
            sHelpID = "health.explain.blue";
        } else if (health == 3) {
            sHelpID = "health.explain.yellow";
        } else if (health != 6) {
            sHelpID = "health.explain.grey";
        }
        String string = sToolTip = health == 6 && dm != null ? dm.getErrorDetails() : MessageText.getString(sHelpID);
        if (ht != null) {
            sToolTip = sToolTip + "\n" + MessageText.getString("health.explain.share");
        }
        cell.setToolTip(sToolTip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellPaint(GC gc, TableCellSWT cell) {
        Comparable sortValue = cell.getSortValue();
        if (!(sortValue instanceof Long)) {
            return;
        }
        boolean isShare = false;
        long health = (Long)sortValue;
        if (health >= 256L) {
            health -= 256L;
            isShare = true;
        }
        String image_name = health == 5L ? "st_ko" : (health == 4L ? "st_ok" : (health == 2L ? "st_no_tracker" : (health == 3L ? "st_no_remote" : (health == 6L ? "st_error" : "st_stopped"))));
        if (isShare) {
            image_name = image_name + "_shared";
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image img = imageLoader.getImage(image_name);
        try {
            Rectangle cellBounds = cell.getBounds();
            if (img != null && !img.isDisposed()) {
                Rectangle imgBounds = img.getBounds();
                gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
            }
        }
        finally {
            imageLoader.releaseImage(image_name);
        }
    }
}

