/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.util.AZ3Functions;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseMoveListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerCellUtils;

public class TrackerStatusItem
extends CoreTableColumn
implements TableCellAddedListener,
TableCellToolTipListener,
TableCellMouseMoveListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tracker";

    public TrackerStatusItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 90, sTableID);
        this.setRefreshInterval(15);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{COLUMN_ID});
        info.setProficiency((byte)1);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Object ds = event2.cell.getDataSource();
        if (!(ds instanceof DownloadManager)) {
            return;
        }
        DownloadManager dm = (DownloadManager)ds;
        AZ3Functions.provider az3 = AZ3Functions.getProvider();
        if (az3 == null || !az3.canShowCDP(dm)) {
            return;
        }
        if (!(event2.cell instanceof TableCellSWT)) {
            return;
        }
        TableCellSWT cell = (TableCellSWT)event2.cell;
        boolean invalidateAndRefresh = false;
        int newCursor = dm.isUnauthorisedOnTracker() ? 21 : 0;
        int oldCursor = cell.getCursorID();
        if (oldCursor != newCursor) {
            invalidateAndRefresh = true;
            cell.setCursorID(newCursor);
        }
        if (event2.eventType == 1 && newCursor == 21) {
            az3.showCDP(dm, "tracker.unauth");
        }
        if (invalidateAndRefresh) {
            cell.invalidate();
            cell.redraw();
        }
    }

    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        cell.setToolTip(TrackerCellUtils.getTooltipText(cell, dm, true));
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }

    private class Cell
    extends AbstractTrackerCell {
        public Cell(TableCell cell) {
            super(cell);
        }

        public void refresh(TableCell cell) {
            super.refresh(cell);
            String status = this.dm == null ? "" : this.dm.getTrackerStatus();
            int nl_pos = status.indexOf(10);
            if (nl_pos >= 0) {
                status = status.substring(0, nl_pos);
            }
            if (cell.setText(status) || !cell.isValid()) {
                TrackerCellUtils.updateColor(cell, this.dm, true);
            }
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            this.checkScrapeResult(response);
        }

        public void announceResult(TRTrackerAnnouncerResponse response) {
            this.cell.invalidate();
        }
    }
}

