/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class LANItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "lan";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    public LANItem(String table_id) {
        super(COLUMN_ID, 3, -1, 20, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        boolean lan = peer == null ? false : peer.isLANLocal();
        if (!cell.setSortValue(lan ? 1L : 0L) && cell.isValid()) {
            return;
        }
        cell.setText(lan ? "*" : "");
        TableRow row = cell.getTableRow();
        if (row != null) {
            row.setForeground(Utils.colorToIntArray((Color)(lan ? Colors.blue : null)));
        }
    }
}

