/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.welcome;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class WelcomeWindow {
    private static final String URL_WHATSNEW = "http://www.vuze.com/releasenotes";
    private static final String lineSeparator = System.getProperty("line.separator");
    Display display;
    Shell shell;
    Color black;
    Color white;
    Color light;
    Color grey;
    Color green;
    Color blue;
    Color fg;
    Color bg;
    String sWhatsNew;
    Font monospace;

    public WelcomeWindow(Shell parentShell) {
        try {
            this.init(parentShell);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void init(Shell parentShell) {
        this.shell = ShellFactory.createShell(parentShell, 2160);
        Utils.setShellIcon(this.shell);
        this.monospace = Constants.isOSX ? new Font((Device)this.shell.getDisplay(), "Courier", 12, 0) : new Font((Device)this.shell.getDisplay(), "Courier New", 8, 0);
        this.shell.setText(MessageText.getString("window.welcome.title", new String[]{"4.2.0.8"}));
        this.display = this.shell.getDisplay();
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        Composite cWhatsNew = new Composite((Composite)this.shell, 2048);
        GridData data = new GridData(1808);
        cWhatsNew.setLayoutData((Object)data);
        cWhatsNew.setLayout((Layout)new FillLayout());
        Button bClose = new Button((Composite)this.shell, 8);
        bClose.setText(MessageText.getString("Button.close"));
        data = new GridData();
        data.widthHint = 70;
        data.horizontalAlignment = Constants.isOSX ? 0x1000000 : 131072;
        bClose.setLayoutData((Object)data);
        Listener closeListener2 = new Listener(){

            public void handleEvent(Event event2) {
                WelcomeWindow.this.close();
            }
        };
        bClose.addListener(13, closeListener2);
        this.shell.addListener(21, closeListener2);
        this.shell.setDefaultButton(bClose);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    WelcomeWindow.this.close();
                }
            }
        });
        this.shell.setSize(750, 500);
        Utils.centreWindow(this.shell);
        this.shell.layout();
        this.shell.open();
        this.fillWhatsNew(cWhatsNew);
    }

    private void fillWhatsNew(Composite cWhatsNew) {
        Label label = new Label(cWhatsNew, 0x1000000);
        label.setText(MessageText.getString("installPluginsWizard.details.loading"));
        this.shell.layout(true, true);
        this.shell.update();
        String helpFile = MessageText.getString("window.welcome.file");
        if ((this.sWhatsNew == null || this.sWhatsNew.length() == 0) && helpFile.toLowerCase().startsWith("http://azureus.sourceforge.net/")) {
            this.sWhatsNew = this.getWhatsNew(helpFile);
            if (this.shell.isDisposed()) {
                return;
            }
        }
        if (this.sWhatsNew == null || this.sWhatsNew.length() == 0) {
            helpFile = "http://www.vuze.com/releasenotes?version=4.2.0.8&locale=" + Locale.getDefault().toString() + "&ui=" + COConfigurationManager.getStringParameter("ui");
            this.sWhatsNew = this.getWhatsNew(helpFile);
            if (this.shell.isDisposed()) {
                return;
            }
        }
        if (this.sWhatsNew == null || this.sWhatsNew.length() == 0) {
            InputStream stream = this.getClass().getResourceAsStream(helpFile);
            if (stream == null) {
                String helpFullPath = "/org/gudy/azureus2/internat/whatsnew/" + helpFile;
                stream = this.getClass().getResourceAsStream(helpFullPath);
            }
            if (stream == null) {
                stream = this.getClass().getResourceAsStream("/ChangeLog.txt");
            }
            if (stream == null) {
                this.sWhatsNew = "Welcome Window: Error loading resource: " + helpFile;
            } else {
                try {
                    this.sWhatsNew = FileUtil.readInputStreamAsString(stream, 65535, "utf8");
                    stream.close();
                }
                catch (IOException e) {
                    Debug.out(e);
                }
            }
        }
        if (this.sWhatsNew.indexOf("<html") >= 0 || this.sWhatsNew.indexOf("<HTML") >= 0) {
            try {
                Browser browser = new Browser(cWhatsNew, Utils.getInitialBrowserStyle(0));
                browser.setText(this.sWhatsNew);
            }
            catch (Throwable t) {
                try {
                    File tempFile = File.createTempFile("AZU", ".html");
                    tempFile.deleteOnExit();
                    FileUtil.writeBytesAsFile(tempFile.getAbsolutePath(), this.sWhatsNew.getBytes("utf8"));
                    Utils.launch(tempFile.getAbsolutePath());
                    this.shell.dispose();
                    return;
                }
                catch (IOException e) {}
            }
        } else {
            StyledText helpPanel = new StyledText(cWhatsNew, 768);
            helpPanel.setEditable(false);
            try {
                helpPanel.setRedraw(false);
                helpPanel.setWordWrap(false);
                helpPanel.setFont(this.monospace);
                this.black = ColorCache.getColor((Device)this.display, 0, 0, 0);
                this.white = ColorCache.getColor((Device)this.display, 255, 255, 255);
                this.light = ColorCache.getColor((Device)this.display, 200, 200, 200);
                this.grey = ColorCache.getColor((Device)this.display, 50, 50, 50);
                this.green = ColorCache.getColor((Device)this.display, 30, 80, 30);
                this.blue = ColorCache.getColor((Device)this.display, 20, 20, 80);
                helpPanel.setForeground(this.grey);
                String[] lines = this.sWhatsNew.split("\\r?\\n");
                for (int i = 0; i < lines.length; ++i) {
                    String text;
                    char styleChar;
                    String line = lines[i];
                    boolean setStyle = false;
                    this.fg = this.grey;
                    this.bg = this.white;
                    int style = 0;
                    if (line.length() < 2) {
                        styleChar = ' ';
                        text = " " + lineSeparator;
                    } else {
                        styleChar = line.charAt(0);
                        text = line.substring(1) + lineSeparator;
                    }
                    switch (styleChar) {
                        case '*': {
                            text = "  * " + text;
                            this.fg = this.green;
                            setStyle = true;
                            break;
                        }
                        case '+': {
                            text = "     " + text;
                            this.fg = this.black;
                            this.bg = this.light;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case '!': {
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case '@': {
                            this.fg = this.blue;
                            setStyle = true;
                            break;
                        }
                        case '$': {
                            this.bg = this.blue;
                            this.fg = this.white;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case ' ': {
                            text = "  " + text;
                            break;
                        }
                        default: {
                            text = styleChar + text;
                        }
                    }
                    helpPanel.append(text);
                    if (!setStyle) continue;
                    int lineCount = helpPanel.getLineCount() - 1;
                    int charCount = helpPanel.getCharCount();
                    int lineOfs = helpPanel.getOffsetAtLine(lineCount - 1);
                    int lineLen = charCount - lineOfs;
                    helpPanel.setStyleRange(new StyleRange(lineOfs, lineLen, this.fg, this.bg, style));
                    helpPanel.setLineBackground(lineCount - 1, 1, this.bg);
                }
                helpPanel.setRedraw(true);
            }
            catch (Exception e) {
                System.out.println("Unable to load help contents because:" + e);
            }
        }
        label.dispose();
        this.shell.layout(true, true);
    }

    private String getWhatsNew(final String url) {
        final String[] s = new String[1];
        new AEThread("getWhatsNew", true){

            public void runSupport() {
                ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                try {
                    ResourceDownloader rd = rdf.create(new URL(url));
                    InputStream is = rd.download();
                    int length = is.available();
                    byte[] data = new byte[length];
                    is.read(data);
                    is.close();
                    s[0] = new String(data);
                }
                catch (ResourceDownloaderException rde) {
                    s[0] = "";
                }
                catch (Exception e) {
                    Debug.out(e);
                    s[0] = "";
                }
                if (!WelcomeWindow.this.shell.isDisposed()) {
                    WelcomeWindow.this.shell.getDisplay().wake();
                }
            }
        }.start();
        while (!this.shell.isDisposed() && s[0] == null) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return s[0];
    }

    private void close() {
        this.monospace.dispose();
        this.shell.dispose();
    }

    public static void main(String[] args) {
        System.out.println(Locale.getDefault().getCountry());
        new WelcomeWindow(null);
        Display display = Display.getDefault();
        while (true) {
            if (display.readAndDispatch()) {
                continue;
            }
            display.sleep();
        }
    }
}

