/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.win32;

import com.aelitis.azureus.core.drivedetector.DriveDetectedInfo;
import com.aelitis.azureus.core.drivedetector.DriveDetector;
import com.aelitis.azureus.core.drivedetector.DriveDetectorFactory;
import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.platform.win32.access.AEWin32Manager;

public class Win32UIEnhancer {
    public static final boolean DEBUG = false;
    public static final int WM_DEVICECHANGE = 537;
    public static final int DBT_DEVICEARRIVAL = 32768;
    public static final int DBT_DEVICEREMOVECOMPLETE = 32772;
    public static final int DBT_DEVTYP_VOLUME = 2;
    private static int messageProc;
    private static Callback messageCallback;
    private static DriveDetectedInfo loc;

    static String findProgramKey(String extension) {
        TCHAR lpData;
        int[] phkResult;
        TCHAR key;
        if (extension == null) {
            SWT.error((int)4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        if (OS.RegOpenKeyEx((int)Integer.MIN_VALUE, (TCHAR)(key = new TCHAR(0, extension, true)), (int)0, (int)131097, (int[])(phkResult = new int[1])) != 0) {
            return null;
        }
        int[] lpcbData = new int[1];
        int result = OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)null, (int[])lpcbData);
        if (result == 0 && (result = OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)(lpData = new TCHAR(0, lpcbData[0] / TCHAR.sizeof)), (int[])lpcbData)) == 0) {
            return lpData.toString(0, lpData.strlen());
        }
        OS.RegCloseKey((int)phkResult[0]);
        return null;
    }

    public static ImageData getBigImageData(String extension) {
        String key = Win32UIEnhancer.findProgramKey(extension);
        if (key == null) {
            return null;
        }
        String DEFAULT_ICON = "\\DefaultIcon";
        String iconName = Win32UIEnhancer.getKeyValue(key + DEFAULT_ICON, true);
        if (iconName == null) {
            iconName = "";
        }
        int nIconIndex = 0;
        String fileName = iconName;
        int index = iconName.indexOf(44);
        if (index != -1) {
            fileName = iconName.substring(0, index);
            String iconIndex = iconName.substring(index + 1, iconName.length()).trim();
            try {
                nIconIndex = Integer.parseInt(iconIndex);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        TCHAR lpszFile = new TCHAR(0, fileName, true);
        int[] phiconSmall = null;
        int[] phiconLarge = new int[1];
        OS.ExtractIconEx((TCHAR)lpszFile, (int)nIconIndex, (int[])phiconLarge, phiconSmall, (int)1);
        if (phiconLarge[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, (int)1, (int)phiconLarge[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    static String getKeyValue(String string, boolean expand) {
        TCHAR key = new TCHAR(0, string, true);
        int[] phkResult = new int[1];
        if (OS.RegOpenKeyEx((int)Integer.MIN_VALUE, (TCHAR)key, (int)0, (int)131097, (int[])phkResult) != 0) {
            return null;
        }
        String result = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx((int)phkResult[0], (TCHAR)null, (int)0, null, (TCHAR)null, (int[])lpcbData) == 0) {
            TCHAR lpData;
            result = "";
            int length = lpcbData[0] / TCHAR.sizeof;
            if (length != 0 && OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)(lpData = new TCHAR(0, length)), (int[])lpcbData) == 0) {
                if (!OS.IsWinCE && expand) {
                    length = OS.ExpandEnvironmentStrings((TCHAR)lpData, null, (int)0);
                    if (length != 0) {
                        TCHAR lpDst = new TCHAR(0, length);
                        OS.ExpandEnvironmentStrings((TCHAR)lpData, (TCHAR)lpDst, (int)length);
                        result = lpDst.toString(0, Math.max(0, length - 1));
                    }
                } else {
                    length = Math.max(0, lpData.length() - 1);
                    result = lpData.toString(0, length);
                }
            }
        }
        if (phkResult[0] != 0) {
            OS.RegCloseKey((int)phkResult[0]);
        }
        return result;
    }

    public static void initMainShell(Shell shell) {
        File[] drives;
        Shell subshell = new Shell(shell);
        messageCallback = new Callback(Win32UIEnhancer.class, "messageProc2", 4);
        messageProc = messageCallback.getAddress();
        if (messageProc != 0) {
            OS.SetWindowLongPtr((int)subshell.handle, (int)-4, (int)messageProc);
        }
        if ((drives = AEWin32Manager.getAccessor(false).getUSBDrives()) != null) {
            for (File file : drives) {
                DriveDetectorFactory.getDeviceDetector().driveDetected(file);
            }
        }
    }

    static int messageProc2(int hwnd, int msg, int wParam, int lParam) {
        try {
            switch (msg) {
                case 537: {
                    if (wParam == 32768) {
                        int[] st = new int[3];
                        OS.memmove((int[])st, (int)lParam, (int)12);
                        if (st[1] == 2) {
                            byte[] b = new byte[st[0]];
                            OS.memmove((byte[])b, (int)lParam, (int)st[0]);
                            long unitMask = b[12] + (b[13] << 8) + (b[14] << 16) + (b[14] << 24);
                            char letter = '?';
                            for (int i = 0; i < 26; ++i) {
                                if ((long)(1 << i) != unitMask) continue;
                                letter = (char)(65 + i);
                            }
                            if (letter != '?') {
                                DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                                driveDetector.driveDetected(new File(letter + ":\\"));
                            }
                        }
                        break;
                    }
                    if (wParam != 32772) break;
                    int[] st = new int[3];
                    OS.memmove((int[])st, (int)lParam, (int)12);
                    if (st[1] != 2) break;
                    byte[] b = new byte[st[0]];
                    OS.memmove((byte[])b, (int)lParam, (int)st[0]);
                    long unitMask = b[12] + (b[13] << 8) + (b[14] << 16) + (b[14] << 24);
                    char letter = '?';
                    for (int i = 0; i < 26; ++i) {
                        if ((long)(1 << i) != unitMask) continue;
                        letter = (char)(65 + i);
                    }
                    if (letter == 63) break;
                    DriveDetector driveDetector = DriveDetectorFactory.getDeviceDetector();
                    driveDetector.driveRemoved(new File(letter + ":\\"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

