#include <QtGui>

#include "ipQalc.h"




ipQalc::ipQalc(QWidget *parent) : QWidget(parent){
    ui.setupUi(this);

    connect(ui.cmdClose, SIGNAL(clicked()), qApp, SLOT(quit()));
    connect(ui.Command1, SIGNAL(clicked()), this, SLOT(calc()));
    
    ui.Ip->setText("192.168.200.123");
    ui.NetMask->setText("255.255.255.0");
    

}

void ipQalc::calc() {


    if (isValidIP(ui.Ip->text())==false ){        
        //"Неправильно набран IP адрес"
        QMessageBox::warning(this,"Error",tr("Invalid Input IP address"));
        return;
    }

    if (isValidMask(ui.NetMask->text())==false ){
        // "Неправильно набрана маска сети"
        QMessageBox::warning(this,"Error",tr("Invalid Input Netmask."));
        return;
    }


    SubNet = new IpAdress(ui.Ip->text(),ui.NetMask->text());


    ui.label_4->setText(SubNet->GetIpAdress(10));
    ui.label_5->setText(SubNet->GetIpAdress(2));
    ui.label_6->setText(SubNet->GetIpAdress(16));

    ui.label_8->setText(SubNet->GetNetMask(10));
    ui.label_9->setText(SubNet->GetNetMask(2));
    ui.label_10->setText(SubNet->GetNetMask(16));
    
    ui.label_12->setText(SubNet->GetInversMask(10));
    ui.label_13->setText(SubNet->GetInversMask(2));
    ui.label_14->setText(SubNet->GetInversMask(16));

    ui.label_16->setText(SubNet->GetMaskPrefix());

    ui.label_18->setText(SubNet->GetNetAdress(10));
    ui.label_19->setText(SubNet->GetNetAdress(2));
    ui.label_20->setText(SubNet->GetNetAdress(16));

    ui.label_22->setText(SubNet->GetBroadCast(10));
    ui.label_23->setText(SubNet->GetBroadCast(2));
    ui.label_24->setText(SubNet->GetBroadCast(16));

    ui.label_26->setText(SubNet->GetMinIP(10));
    ui.label_27->setText(SubNet->GetMinIP(2));
    ui.label_28->setText(SubNet->GetMinIP(16));

    ui.label_30->setText(SubNet->GetMaxIP(10));
    ui.label_31->setText(SubNet->GetMaxIP(2));
    ui.label_32->setText(SubNet->GetMaxIP(16));
    
    ui.label_34->setText(SubNet->GetHosts());
    
    
}


bool ipQalc::isValidIP(QString ipAdress){
    QRegExp rx( "\\b(([01]?\\d?\\d|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d?\\d|2[0-4]\\d|25[0-5])\\b" );
    if (!rx.exactMatch(ipAdress)){
	return false;
    }

    return true;
}

bool ipQalc::isValidMask(QString ipAdress){

    if (isValidIP(ipAdress)==false) return false;

    QString str = "";
    QStringList strList;
    QByteArray text;
    bool ok;

    QStringList adr = ipAdress.split(".");
    for (int i=0;i<4;i++){
        text.setNum(adr[i].toInt(&ok,10),2);
        strList.append(text);

	int len=strList[i].length();
        for (int x=0;x<(8-len);x++){
            strList[i].insert(0,"0");
        }

    }

    str = strList.join("");

    for (int i=0;i<32;i++){
	if (str.mid(i,1) == "0" and str.mid(i+1,1) == "1"){
	    return false;
	}
    }

    return true;
}
