// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <iostream>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include <kdebug.h>
#include "application.h"
#include "mainwindow.h"
#include "profiledialog.h"

LightHawk::Application::Application(void)
	: KUniqueApplication()
	, firstTime(true)
{
}

int LightHawk::Application::newInstance(void)
{
	if(firstTime && isRestored())
	{
		firstTime = false;
		restoreWindows();
	}
	else
	{
		// Don't start the default profile *every* time
		bool f = firstTime;
		firstTime = false;

		// TODO: check profileNames, too
		QString profile = ProfileDialog::defaultProfile();
		if(f && KCmdLineArgs::parsedArgs()->isSet("profile"))
			profile = QString::fromLocal8Bit(KCmdLineArgs::parsedArgs()->getOption("profile"));

		if(!f || profile == QString::null)
		{
			ProfileDialog dlg;
			if(!dlg.exec()) return 0;

			profile = dlg.profileSelected();
		}

		LightHawk::MainWindow *window = new LightHawk::MainWindow(profile);
		window->show();
	}

	return KUniqueApplication::newInstance();
}

void LightHawk::Application::restoreWindows(void)
{
	for(int i = 1; LightHawk::MainWindow::canBeRestored(i); ++i)
	{
		sessionConfig()->setGroup(QString::number(i));
		QString profile = sessionConfig()->readEntry("LHProfile",
		                                             ProfileDialog::defaultProfile());
		LightHawk::MainWindow *window = new LightHawk::MainWindow(profile);
		window->restore(i);
	}
}

void LightHawk::Application::addCmdLineOptions(void)
{
	KUniqueApplication::addCmdLineOptions();
}

#include "application.moc"
// arch-tag: application.cpp
