// Copyright (C) 2001 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kcombobox.h>
#include <klocale.h>
#include <qlabel.h>
#include <qlayout.h>

#include "comboboxdialog.h"

LightHawk::ComboBoxDialog::ComboBoxDialog(const QString &_prompt, const QStringList &_list, QWidget *_parent)
	: KDialogBase(_parent, 0, true, QString::null, Ok | Cancel | User1, Ok, true, i18n("Clear"))
{
	QFrame *frame = makeMainWidget();
	QVBoxLayout *layout = new QVBoxLayout(frame, 0, spacingHint());
	layout->setAutoAdd(true);

	(void)new QLabel(_prompt, frame);

	box = new KComboBox(true, frame);
	box->insertStringList(_list);

	connect(this, SIGNAL(user1Clicked()), box, SLOT(clearEdit()));
}

LightHawk::ComboBoxDialog::~ComboBoxDialog()
{
}

QString LightHawk::ComboBoxDialog::text(void)
{
	return box->currentText();
}

QString LightHawk::ComboBoxDialog::getText(const QString &_prompt, const QStringList &_list, QWidget *_parent)
{
	ComboBoxDialog dlg(_prompt, _list, _parent);
	if(dlg.exec())
		return dlg.text();
	else
		return QString::null;
}

#include "comboboxdialog.moc"
// arch-tag: comboboxdialog.cpp
