// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kconfig.h>
#include <kdebug.h>
#include <keditcl.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klineedit.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvbox.h>
#include "configdialog.h"
#include "pages.h"

LightHawk::ConfigDialog::ConfigDialog(ConfigManager &m, QWidget *parent, const char *n)
	: KDialogBase(IconList, i18n("Settings"), Ok | Apply | Cancel, Ok, parent,
	              n, 0, true)
	, manager(m)
{
	pages.setAutoDelete(false);

	addPage(new IdentityPage(this));
	addPage(new MessagePage(this));
	addPage(new RosterPage(this));

	for(QPtrListIterator<ConfigPage> i(pages); *i; ++i)
		(**i).apply(manager.config());

	resize(640, 480);
}

void LightHawk::ConfigDialog::accept(void)
{
	createResult();
	KDialogBase::accept();
}

void LightHawk::ConfigDialog::slotApply(void)
{
	createResult();
	KDialogBase::slotApply();
}

void LightHawk::ConfigDialog::slotOk(void)
{
	createResult();
	KDialogBase::slotOk();
}

void LightHawk::ConfigDialog::createResult(void)
{
	for(QPtrListIterator<ConfigPage> i(pages); *i; ++i)
		(**i).createResult(manager.config());
}


void LightHawk::ConfigDialog::addPage(ConfigPage *page)
{
	pages.append(page);
	QFrame *frame = addVBoxPage(page->pageName(), page->pageHeader(), page->pagePixmap());
	page->reparent(frame, QPoint(0, 0));
}

#include "configdialog.moc"
// arch-tag: configdialog.cpp
