// Copyright (C) 2003 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kdebug.h>
#include "configmanager.h"

LightHawk::ConfigManager::ConfigManager(const QString &p, QObject *parent, const char *name)
	: QObject(parent, name)
	, profile(p)
{
}

LightHawk::ConfigManager::~ConfigManager(void)
{
}

LightHawk::Data &LightHawk::ConfigManager::config(void)
{
	return data;
}

void LightHawk::ConfigManager::readData(KConfig &config)
{
	data.setRawMap(config.entryMap(groupForProfile(profile)));
}

void LightHawk::ConfigManager::writeData(KConfig &config)
{
	config.setGroup(groupForProfile(profile));
	QMap<QString, QString> map = data.rawMap();
	for(QMap<QString, QString>::Iterator i = map.begin(); i != map.end(); ++i)
		config.writeEntry(i.key(), i.data());
	config.sync();
}

QString LightHawk::ConfigManager::groupForProfile(const QString &profile)
{
	return QString("Profile - %1").arg(profile);
}

#include "configmanager.moc"
// arch-tag: configmanager.cpp
