// Copyright (C) 2003 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_CONFIGPAGE_H
#define LIGHTHAWK_CONFIGPAGE_H

#include <kconfigbase.h>
#include <kcmodule.h>
#include <qmap.h>

namespace LightHawk
{

// Note: groups cannot contain the / character
class Data : public KConfigBase
{
Q_OBJECT

public:
	Data(void);
	virtual ~Data(void);

	virtual QStringList groupList(void) const;
	virtual QMap<QString,QString> entryMap(const QString &) const;
	virtual void reparseConfiguration(void);

	QMap<QString, QString> rawMap(void) const;
	void setRawMap(const QMap<QString, QString> &);

protected:
	virtual KEntryMap internalEntryMap(const QString &) const;
	virtual KEntryMap internalEntryMap(void) const;
	virtual void putData(const KEntryKey &, const KEntry &, bool = true);
	virtual KEntry lookupData(const KEntryKey &) const;
	virtual bool internalHasGroup(const QCString &) const;

private:
	struct PrivateData;
	PrivateData *d;
};

class ConfigPage : public KCModule
{
Q_OBJECT

public:
	ConfigPage(QWidget *parent, const char *name);

	virtual void apply(Data &) = 0;
	virtual void createResult(Data &) = 0;

	virtual QString pageName(void) = 0;
	virtual QString pageHeader(void) = 0;
	virtual QPixmap pagePixmap(void) = 0;
};

}

#endif
// arch-tag: liblighthawk/configpage.h
