// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kdebug.h>
#include <kiconloader.h>
#include <liblighthawk/utils.h>
#include "messagewindow.h"
#include "pluginparent.h"

struct LightHawk::MessageWindow::PrivateData
{
	Data *data;
};

LightHawk::MessageWindow::MessageWindow(QWidget *parent, const char *name, const QStringList &)
	: KParts::MainWindow(0, name)
	, d(new PrivateData)
{
	d->data = &dynamic_cast<PluginParent *>(parent)->config();
	setIcon(DesktopIcon("lighthawk"));
}

LightHawk::MessageWindow::~MessageWindow()
{
	emit closing(this);

	delete d;
	d = 0;
}

void LightHawk::MessageWindow::setMyself(const XMPP::Jid &j, const QString &n)
{
	myJid = j;
	myNickname = n;
	jidChanged();
}

void LightHawk::MessageWindow::setPeer(const XMPP::Jid &j, const QString &n)
{
	hisJid = j;
	hisNickname = n;
	jidChanged();
}

void LightHawk::MessageWindow::setType(const QString &t)
{
	replyMessageType = t;
	typeChanged();
}

const XMPP::Jid &LightHawk::MessageWindow::myself(void)
{
	return myJid;
}

const XMPP::Jid &LightHawk::MessageWindow::peer(void)
{
	return hisJid;
}

QString LightHawk::MessageWindow::type(void)
{
	return replyMessageType;
}

void LightHawk::MessageWindow::messageIn(const XMPP::Message &)
{
}

LightHawk::Data &LightHawk::MessageWindow::config(void)
{
	return *(d->data);
}

void LightHawk::MessageWindow::closeEvent(QCloseEvent *e)
{
	mainWindowWorkaround(this);
	// Yes, I'm bypassing the KMainWindow closeEvent.  I have to in order
	// to avoid the bug.
	KParts::MainWindow::closeEvent(e);
}

#include "messagewindow.moc"
// arch-tag: liblighthawk/messagewindow.cpp
