// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_MESSAGEWINDOW_H
#define LIGHTHAWK_MESSAGEWINDOW_H

#include <kparts/mainwindow.h>
#include <liblighthawk/configpage.h>
#include <zinv/jid.h>
#include <zinv/message.h>
#include <zinv/types.h>

namespace LightHawk
{

class MessageWindow : public KParts::MainWindow
{
Q_OBJECT
public:
	// moc chokes on namespaces
	typedef XMPP::Jid Jid;
	typedef XMPP::Message Message;
	typedef XMPP::Resource Resource;

	MessageWindow(QWidget *, const char *, const QStringList &);
	virtual ~MessageWindow(void);

	void setMyself(const XMPP::Jid &, const QString &);

	void setPeer(const XMPP::Jid &, const QString &);

	void setType(const QString &);

	const XMPP::Jid &myself(void);
	const XMPP::Jid &peer(void);
	QString type(void);

public slots:
	/**
	 * If this isn't implemented in your inherited class, the user is in big
	 * trouble, and will probably not want to use your plugin.
	 */
	virtual void messageIn(const Message &) = 0;

	/**
	 * Information about your jid has been received.
	 * This is especially useful for Group Chat plugins
	 */
	virtual void resourceUpdate(const Jid &, const Resource &) = 0;

	/**
	 * Insert the specified text into the user's text edit
	 */
	virtual void insertText(const QString &) = 0;

signals:
	/**
	 * Lets the app know a message is to be sent.
	 */
	void messageOut(const Message &);

	/**
	 * Lets the app know when the window gets closed.
	 */
	void closing(MessageWindow *);

	/**
	 * Emit this when you want the roster item editor to appear
	 */
	void addContact(const Jid &);

protected:
	/**
	 * Set your caption or whatever
	 */
	virtual void jidChanged(void) = 0;

	/**
	 * Message type is important
	 */
	virtual void typeChanged(void) = 0;

	/**
	 * Read and store configuration
	 */
	Data &config(void);

	XMPP::Jid myJid, hisJid;
	QString myNickname, hisNickname;
	QString replyMessageType;

protected slots:
	/**
	 * Respond to changes in the user configuration here
	 */
	virtual void applyPreferences(void) = 0;


protected:
	/**
	 * Reimplemented to avoid a bug where closing the last message window
	 * while the main window is hidden causes LH to quit
	 */
	virtual void closeEvent(QCloseEvent *);

private:
	struct PrivateData;
	PrivateData *d;
};

}

#endif
// arch-tag: liblighthawk/messagewindow.h
