// Copyright (C) 2003 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kapplication.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <kmainwindow.h>
#include "utils.h"

QString LightHawk::htmlEscape(QString string)
{
	string.replace('&', "&amp;");
	string.replace('<', "&lt;");
	string.replace('>', "&gt;");
	return string;
}

QString LightHawk::htmlQuote(QString string)
{
	string = htmlEscape(string);
	string.replace('"', "\\\"");
	string = QString("\"%1\"").arg(string);
	return string;
}

QString LightHawk::htmlFont(const QFont &font)
{
	QString fontString;

	if(font.italic())
		fontString += "font-style: italic;\n";

	fontString += QString("font-weight: %1;\n").arg(font.weight() * 10);

	if(font.pointSize() != -1)
		fontString += QString("font-size: %1pt;\n").arg(font.pointSize());
	else if(font.pixelSize() != -1)
		fontString += QString("font-size: %1px;\n").arg(font.pixelSize());
	else
		fontString += QString("font-size: %1pt;\n").arg(font.pointSizeFloat());

	fontString += QString("font-family: %1;\n").arg(htmlQuote(font.family()));

	return fontString;
}

namespace
{
QString iconForStatus(XMPP::Status status)
{
	if(!status.isAvailable())
		return "unavailable";
	else if(status.show().isEmpty())
		return "available";
	else
		return status.show();
}
}

QPixmap LightHawk::smallIconForStatus(XMPP::Status status)
{
	return SmallIcon(iconForStatus(status));
}

QPixmap LightHawk::barIconForStatus(XMPP::Status status)
{
	return BarIcon(iconForStatus(status));
}

QPixmap LightHawk::trayIconForStatus(XMPP::Status status)
{
	return KGlobal::iconLoader()->loadIcon(iconForStatus(status), KIcon::Toolbar, 22);
}

void LightHawk::mainWindowWorkaround(KMainWindow *me)
{
	int topLevelWithdrawn = 0;
	for(QPtrListIterator<KMainWindow> i(*KMainWindow::memberList); *i; ++i)
	{
		KMainWindow *window = *i;
		if(window->isHidden() && window->isTopLevel() && window != me)
			++topLevelWithdrawn;
	}
	if(topLevelWithdrawn)
	{
		kapp->ref();
	}
}

// arch-tag: liblighthawk/utils.cpp
