// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>

#include "application.h"

const char *license = "Copyright (C) 2002 Neil Stevens <neil@hakubi.us>\n\
\n\
Permission is hereby granted, free of charge, to any person obtaining a copy\n\
of this software and associated documentation files (the ""Software""), to deal\n\
in the Software without restriction, including without limitation the rights\n\
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n\
copies of the Software, and to permit persons to whom the Software is\n\
furnished to do so, subject to the following conditions:\n\
\n\
The above copyright notice and this permission notice shall be included in\n\
all copies or substantial portions of the Software.\n\
\n\
THE SOFTWARE IS PROVIDED ""AS IS"", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n\
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n\
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE\n\
THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN\n\
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n\
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n\
\n\
Except as contained in this notice, the name(s) of the author(s) shall not be\n\
used in advertising or otherwise to promote the sale, use or other dealings\n\
in this Software without prior written authorization from the author(s).";

void noMessageOutput(QtMsgType, const char *)
{
}

static KCmdLineOptions options[] =
{
	{ "profile <profile>", I18N_NOOP("Profile to open."), 0 },
#ifndef NDEBUG
	{ "qdebug", I18N_NOOP("Turn on Qt Debug output"), 0 },
#endif
	{ 0, 0, 0}
};

int main(int argc, char **argv)
{
	// about data
	KAboutData aboutData("lighthawk", I18N_NOOP("Light Hawk"), "0.6",
	                     I18N_NOOP("Jabber client"), KAboutData::License_Custom, 0,
	                     0, "http://www.hakubi.us/lighthawk/", "bugs@hakubi.us");

	aboutData.addAuthor("Neil Stevens", I18N_NOOP("Author"), "neil@hakubi.us");
	aboutData.addCredit("James Blomo", I18N_NOOP("Early contributions that kept this project alive"), "blackfoot@yifan.net");
	aboutData.addCredit("Shu-yu Guo (郭纾宇)", I18N_NOOP("Beautiful Icons"), "shu@rufuran.org");
	aboutData.addCredit("Justin Karneges", I18N_NOOP("Author of Psi, from which came the Jabber classes this application uses"), "infiniti@affinix.com");
	aboutData.addCredit("United States Army", I18N_NOOP("Preserving the freedom that made this software possible"));
	aboutData.setLicenseText(license);

	// command line
	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);
	LightHawk::Application::addCmdLineOptions();

	LightHawk::Application app;

#ifndef NDEBUG
	if(!KCmdLineArgs::parsedArgs()->isSet("qdebug"))
		qInstallMsgHandler(noMessageOutput);
#endif

	// This is a magic line that fixes SM.  Don't remove it.
	(void)app.sessionConfig();

	if(!LightHawk::Application::start())
	{
		return 0;
	}

	return app.exec();
}
// arch-tag: main.cpp
