// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_WINDOW_H
#define LIGHTHAWK_WINDOW_H

#include <kmainwindow.h>

class KAction;
class KListView;
class KProgressDialog;
class KSelectAction;
class KSystemTray;
class KToggleAction;

namespace XMPP
{
class Client;
class Jid;
class LiveRosterItem;
class Message;
class RosterItem;
class StreamError;
}

namespace LightHawk
{
class ConfigDialog;
class ConfigManager;
class LogManager;
class MessageWindowManager;
class RosterListView;
class SystemTray;

class MainWindow : public KMainWindow
{
Q_OBJECT

public:
	// working around moc's disgraceful lack of namespace awareness
	typedef XMPP::StreamError StreamError;
	typedef XMPP::RosterItem RosterItem;
	typedef XMPP::Jid Jid;
	typedef XMPP::Message Message;

	MainWindow(const QString &profile);

	~MainWindow(void);

	static void closeWindowsForProfile(const QString &);

	XMPP::Jid currentJid(void);

public slots:
	// Actions
	void fileQuit(void);

	void settingsPreferences(void);
	void settingsKeys(void);
	void settingsNotifications(void);
	void profiles(void);

	void groupOpenChat(void);

	void rosterCompose(void);
	void rosterOpenChat(void);
	void rosterEdit(void);
	void rosterAdd(void);
	void rosterRemove(void);
	void rosterAddAgent(void);
	void rosterAddService(void);

	void toolsSendXML(void);

	void available(void);
	void chat(void);
	void away(void);
	void xa(void);
	void dnd(void);
	void invisible(void);
	void unavailable(void);

protected:
	void closeEvent(QCloseEvent *);

	virtual void saveProperties(KConfig *);

private slots:
	void applyPreferences(void);

	// UI handler
	void setPresence(const QString &show, const QString &longShow,
	                 const QString &status = QString::null, bool invisible = false);
	void setPresenceInternal(void);

	// handling the connect sequence
	void connectBegin(void);
	void connectHandshake(void);
	void connectAuthenticate(void);
	void connectGetRoster(bool, int, const QString &);
	void connectComplete(bool, int, const QString &);
	void connectCancel(void);

	// from the roster widget
	void rosterContextMenu(const RosterItem &, const QPoint &);
	void rosterSelectionChanged(void);
	void rosterExecuted(const RosterItem &);

	// from the manager
	void addContact(const Jid &);
	void sendPresence(const Jid &, const QString &);
	void sendMessage(const Message &);

	// from the client
	void clientError(const StreamError &);
	void receiveMessage(const Message &);
	void subscriptionReceived(const Jid &, const QString &);

	// from the config dialog
	void configFinished(void);

signals:
	void connectSuccess(void);

	void preferencesChanged(void);

private:
	const QString profile;
	XMPP::Client &client;
	ConfigManager &configManager;
	LogManager &logManager;
	MessageWindowManager &windowManager;
	KProgressDialog *connectDialog;
	ConfigDialog *configDialog;

	QString setPresenceShow;
	QString setPresenceLongShow;
	QString setPresenceStatus;
	bool setPresenceInvisible;

	RosterListView *listView;
	KPopupMenu *listMenu;
	SystemTray *tray;

	KAction *rosterEditAction;
	KAction *rosterComposeAction, *rosterOpenChatAction;
	KAction *rosterAddAction, *rosterAddServiceAction;
	KAction *rosterRemoveAction;
	KAction *groupOpenChatAction;
	KAction *toolsSendXMLAction;
};

}

#endif
// arch-tag: mainwindow.h
