// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_MESSAGEWINDOWMANAGER_H
#define LIGHTHAWK_MESSAGEWINDOWMANAGER_H

#include <liblighthawk/configpage.h>
#include <liblighthawk/pluginparent.h>
#include <qdict.h>
#include <qmap.h>
#include <qwidget.h>

namespace XMPP
{
class Message;
class Jid;
}

namespace LightHawk
{

class MessageWindow;

/**
 * Manage all the message windows
 */
class MessageWindowManager : public QWidget, public PluginParent
{
Q_OBJECT

public:
	// working around moc's disgraceful lack of namespace awareness
	typedef XMPP::Jid Jid;
	typedef XMPP::Message Message;
	typedef XMPP::Resource Resource;

	MessageWindowManager(Data &, XMPP::Client &, QWidget *, const char * = 0);
	virtual ~MessageWindowManager();

	/**
	 * messageWindow returns the message window for this jid and type,
	 * creating it if necessary.
	 */
	MessageWindow *messageWindow(const XMPP::Jid &from, const XMPP::Jid &to, const QString &type);

	/**
	 * composer returns a normal message composer window
	 */
	MessageWindow *composer(const XMPP::Jid &from, const XMPP::Jid &to);

	virtual Data &config(void);
	virtual XMPP::Client &client(void);

public slots:
	void resourceAvailable(const Jid &, const Resource &);
	void resourceUnavailable(const Jid &, const Resource &);

signals:
	// UI convenience
	void addContact(const Jid &);
	// This is for the closing of groupchat windows
	void presence(const Jid &dest, const QString &type);
	// Basic functionality
	void message(const Message &m);

	void applyPreferences(void);

private:
	QString nameForJid(const Jid &);
	bool resourceForJid(const Jid &, XMPP::Resource &);

	MessageWindow *messageWindowInternal(const XMPP::Jid &, const XMPP::Jid &, const QString &, bool);
	// (*messageWindows[type])[jid] == MessageWindow
	typedef QMap<XMPP::Jid, MessageWindow *> Map;
	typedef QDict<Map> Dict;
	typedef QDictIterator<Map> DictIterator;
	Dict messageWindows;
	Data &data;
	XMPP::Client &c;

private slots:
	void messageWindowClosing(MessageWindow *);
};

}

#endif
// arch-tag: messagewindowmanager.h
