// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_PAGES_H
#define LIGHTHAWK_PAGES_H

#include <liblighthawk/configpage.h>

class QCheckBox;
class QLabel;
class KLineEdit;
class KRestrictedLine;

namespace LightHawk
{

class IdentityPage : public ConfigPage
{
Q_OBJECT

public:
	IdentityPage(QWidget *parent, const char *name = 0);

	virtual void apply(Data &data);
	virtual void createResult(Data &data);

	virtual QString pageName(void);
	virtual QString pageHeader(void);
	virtual QPixmap pagePixmap(void);

private slots:
	void updateSavePassword(void);

private:
	KLineEdit *profileEdit;
	KLineEdit *jidEdit;
	KLineEdit *hostEdit;
	KLineEdit *portEdit;
	KLineEdit *resourceEdit;
	KRestrictedLine *priorityEdit;
	KLineEdit *passwordEdit;
	QCheckBox *savePasswordBox;
	QCheckBox *autoAvailableBox;
};

class MessagePage : public ConfigPage
{
Q_OBJECT

public:
	MessagePage(QWidget *parent, const char *name = 0);

	virtual void apply(Data &data);
	virtual void createResult(Data &data);

	virtual QString pageName(void);
	virtual QString pageHeader(void);
	virtual QPixmap pagePixmap(void);

private slots:
	void selectComposerFont(void);
	void selectViewerFont(void);
	void selectFixedViewerFont(void);

private:
	QCheckBox *loggingBox;
	QCheckBox *timestampingBox;
	QLabel *composerFontLabel;
	QLabel *viewerFontLabel;
	QLabel *fixedViewerFontLabel;
};

class RosterPage : public ConfigPage
{
Q_OBJECT

public:
	RosterPage(QWidget *parent, const char *name = 0);

	virtual void apply(Data &data);
	virtual void createResult(Data &data);

	virtual QString pageName(void);
	virtual QString pageHeader(void);
	virtual QPixmap pagePixmap(void);

private:
	QCheckBox *onlineOnlyBox;
};


}

#endif
// arch-tag: modules.h
