// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef KITCHAT_MESSAGEWINDOW_H
#define KITCHAT_MESSAGEWINDOW_H

#include <liblighthawk/messagewindow.h>

class KAction;
class KHTMLPart;
class KTextEdit;
class KToggleAction;
class QLabel;
class QVBox;

namespace KitChat
{

class MessageWindow : public LightHawk::MessageWindow
{
Q_OBJECT

public:
	MessageWindow(QWidget *, const char *, const QStringList &);
	virtual ~MessageWindow(void);

public slots:
	void setTimestamping(bool);
	void setUsingFixedFont(bool);

	void urlClicked(const KURL &);

	virtual void messageIn(const Message &);

	virtual void resourceUpdate(const Jid &, const Resource &);

	virtual void insertText(const QString &);

protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual void keyPressEvent(QKeyEvent *);
	virtual void keyReleaseEvent(QKeyEvent *);
	virtual bool eventFilter(QObject *, QEvent *);

	virtual void jidChanged(void);
	virtual void typeChanged(void);

	virtual void slotSetStatusBarText(const QString &);


protected slots:
	void send(void);
	// actions
	void clear(void);
	void timestampingPressed(void);
	void soundPressed(void);
	void fixedFontPressed(void);

	virtual void applyPreferences(void);

	void settingsKeys(void);

private:
	void initActions(void);
	void initializeHTML(void);
	void setStylesheet(void);
	void updateHTML(const Message &, const Jid & = "@");

	QFrame *centralWidget;
	KHTMLPart *htmlpart;
	KTextEdit *edit;
	KAction *aClear, *aClose;
	KToggleAction *aTimestamping, *aSound, *aFixedFont;
	QLabel *statusIcon, *statusText;
	bool isTimestamping;
	bool lineBreak;
	QString conversationBuffer;
	bool useSound;
	bool useFixedFont;

	bool receivedResource;
	bool lastResourceAvailable;
};

}

#endif
// arch-tag: plugins/kitchat/messagewindow.h
