// Copyright (C) 2004 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <dcopclient.h>
#include <kaction.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <klocale.h>
#include <liblighthawk/messagewindow.h>
#include <qregexp.h>
#include "noatunplugin.h"

K_EXPORT_COMPONENT_FACTORY(lighthawk_noatunplugin, KGenericFactory<NoatunPlugin::NoatunPlugin>);

NoatunPlugin::NoatunPlugin::NoatunPlugin(QObject *parent, const char *name, const QStringList &)
	: KParts::Plugin(parent, name)
{
	if(!dynamic_cast<LightHawk::MessageWindow *>(parent))
	{
		kdDebug() << "NoatunPlugin: parent not a LightHawk::MessageWindow" << endl;
		return;
	}

	(void)new KAction(i18n("Insert Noatun Track Title"), "noatun", 0, this, SLOT(sayCurrentTrack(void)), actionCollection(), "noatunplugin");
}

void NoatunPlugin::NoatunPlugin::sayCurrentTrack(void)
{
	DCOPClient &client = *kapp->dcopClient();
	if(!client.isAttached())
		client.attach();

	if(!client.registeredApplications().contains("noatun"))
		return;

	if(!client.remoteObjects(QCString("noatun")).contains("Noatun"))
		return;

	// Get playlist URL
	QByteArray replyData;
	QCString replyType;

	if(!client.call(QCString("noatun"), QCString("Noatun"), QCString("title()"),
	   QByteArray(), replyType, replyData))
		return;
	
	if(replyType != QCString("QString")) return;

	QString title;
	QDataStream dataStream(replyData, IO_ReadOnly);
	dataStream >> title;
	title.replace(QRegExp("\\n$"), QString::null);

	static_cast<LightHawk::MessageWindow *>(parent())->insertText(title);
}

#include "noatunplugin.moc"
// arch-tag: plugins/kitchat/noatunplugin.cpp
