// Copyright (C) 2003 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kapplication.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kgenericfactory.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <knotifyclient.h>
#include <kstandarddirs.h>
#include <liblighthawk/utils.h>
#include <qfile.h>
#include <qtextstream.h>

#include "messagewindow.h"

K_EXPORT_COMPONENT_FACTORY(lighthawk_yosho, KGenericFactory<Yosho::MessageWindow>);

Yosho::MessageWindow::MessageWindow(QWidget *parent, const char *name, const QStringList &args)
	: LightHawk::MessageWindow(parent, name, args)
{
	htmlpart = new KHTMLPart(this, 0, this);
	connect(htmlpart->browserExtension(), SIGNAL(openURLRequest(const KURL &, const KParts::URLArgs &)), this, SLOT(urlClicked(const KURL &)));
	htmlpart->setEncoding("utf8", true);
	htmlpart->setStandardFont(KGlobalSettings::generalFont().rawName());
	htmlpart->setFixedFont(KGlobalSettings::fixedFont().rawName());
	htmlpart->setAutoloadImages(false);
	htmlpart->setJScriptEnabled(false);
	htmlpart->setJavaEnabled(false);
	htmlpart->setPluginsEnabled(false);
	htmlpart->show();

	setCentralWidget(htmlpart->view());

	resize(600, 400);
}

void Yosho::MessageWindow::applyPreferences(void)
{
	displayMessage();
}

void Yosho::MessageWindow::messageIn(const Message &message)
{
	lastMessage = message;

	KNotifyClient::event("Message Received");
	//kdDebug() << "messageIn: from: " << lastMessage.from().full() << " to: " << lastMessage.from().full() << endl;

	displayMessage();
}

void Yosho::MessageWindow::displayMessage(void)
{
	htmlpart->begin();
	htmlpart->write(QString("<html><head><style type=\"text/css\">"));

	// Read stylesheet into the document
	QFile file(locate("appdata", "yosho/stylesheet"));
	file.open(IO_ReadOnly);
	QTextStream stream(&file);
	stream.setEncoding(QTextStream::Latin1);
	QString sheet = stream.read();

	QFont font;
	LightHawk::Data &data = config();
	data.setGroup("Message");
	font = data.readFontEntry("viewerFont", &font);
	QString fontString = LightHawk::htmlFont(font);
	sheet.replace("font: MAIN;\n", fontString);
	htmlpart->write(sheet);
	file.close();

	QString subject = lastMessage.subject();
	if(subject.isEmpty())
		subject = i18n("<No Subject>");

	htmlpart->write(QString("</style></head><body><div class=\"header\"><h1>Subject: "));
	htmlpart->write(LightHawk::htmlEscape(subject));
	htmlpart->write(QString("</h1><h2>From: "));
	htmlpart->write(LightHawk::htmlEscape(lastMessage.from().userHost()));
	htmlpart->write(QString("</h2><h2>Date: "));
	htmlpart->write(LightHawk::htmlEscape(KGlobal::locale()->formatDateTime(lastMessage.timeStamp())));
	htmlpart->write(QString("</h2></div><div class=\"body\"><p>"));
	// TODO: rich text where available
	QString body = LightHawk::htmlEscape(lastMessage.body(false));
	body.replace('\n', "<br/>");
	htmlpart->write(body);
	htmlpart->write(QString("</p></body></html>"));
	htmlpart->end();

	setCaption(subject + " - " + lastMessage.from().userHost());
}

void Yosho::MessageWindow::resourceUpdate(const Jid &, const Resource &)
{
}

void Yosho::MessageWindow::insertText(const QString &)
{
}

void Yosho::MessageWindow::jidChanged(void)
{
}

void Yosho::MessageWindow::typeChanged(void)
{
}

void Yosho::MessageWindow::urlClicked(const KURL &url)
{
	kapp->invokeBrowser(url.url());
}

#include "messagewindow.moc"
// arch-tag: plugins/yosho/messagewindow.cpp
