// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_PROFILEDIALOG_H
#define LIGHTHAWK_PROFILEDIALOG_H

#include <kdialogbase.h>
#include <qmap.h>

class QPushButton;
class QListViewItem;
class KListView;

namespace LightHawk
{

class ProfileDialog : public KDialogBase
{
Q_OBJECT

public:
	// returns QString::null if no default
	static QString defaultProfile(void);

	ProfileDialog(QWidget * = 0, const char * = 0);
	
	const QString &profileSelected(void);

protected slots:
	void openClicked(void);
	void setClicked(void);
	void addClicked(void);
	void deleteClicked(void);

	void selectionChanged(QListViewItem *);

protected:
	void updateList(void);

private:
	KListView *profileList;
	QPushButton *openButton;
	QPushButton *setButton;
	QPushButton *addButton;
	QPushButton *deleteButton;

	QMap<QListViewItem *, QString> items;
};

}

#endif
// arch-tag: profiledialog.h
