// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kiconloader.h>
#include <kled.h>
#include <klineedit.h>
#include <klineeditdlg.h>
#include <klistbox.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <zinv/tasks.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include "comboboxdialog.h"
#include "rosteritemdialog.h"

LightHawk::RosterItemDialog::RosterItemDialog(XMPP::Client &c, const XMPP::RosterItem &i, QWidget *p, const char *n)
	: KDialogBase(Plain, i.jid().userHost() + i18n(" - Edit Contact"), Ok|Cancel|Help, Ok, p, n)
	, client(c)
	, item(i)
{
	// Create the widgets
	jidEdit = new KLineEdit(plainPage());
	jidEdit->setReadOnly(true);

	groupListBox = new KListBox(plainPage());
	connect(groupListBox, SIGNAL(selectionChanged()), this, SLOT(groupCurrentChanged()) );
	groupListBox->setSelectionMode(KListBox::Single);
	addButton = new QPushButton(i18n("Add"), plainPage());
	removeButton = new QPushButton(i18n("Remove"), plainPage());
	connect(addButton, SIGNAL(clicked()), this, SLOT(addClicked()) );
	connect(removeButton, SIGNAL(clicked()), this, SLOT(removeClicked()) );

	QFrame *topLine = new QFrame(plainPage());
	QFrame *jidLine = new QFrame(plainPage());
	QFrame *groupsLine = new QFrame(plainPage());
	QFrame *bottomLine = new QFrame(plainPage());
	topLine->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	jidLine->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	groupsLine->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	bottomLine->setFrameStyle(QFrame::HLine | QFrame::Sunken);

	fromLight = new KLed(green, KLed::Off, KLed::Raised, KLed::Circular, plainPage());
	fromLight->setMinimumSize(15, 15);
	toLight = new KLed(green, KLed::Off, KLed::Raised, KLed::Circular, plainPage());
	toLight->setMinimumSize(15, 15);
	subscribeButton = new QPushButton(i18n("Request"), plainPage());
	connect(subscribeButton, SIGNAL(clicked()), this, SLOT(subscribeClicked()) );
	cancelButton = new QPushButton(i18n("Cancel"), plainPage());
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(cancelClicked()) );
	
	// Create the layout
	QGridLayout *grid = new QGridLayout(plainPage()); 
	grid->setSpacing(spacingHint());
	grid->setMargin(marginHint());
	grid->setRowStretch(7, 1);
	grid->setColStretch(2, 1);
	// jid
	grid->addMultiCellWidget(topLine, 0, 0, 0, 2);
	grid->addWidget(new QLabel(i18n("Contact JID"), plainPage()), 1, 0);
	grid->addMultiCellWidget(jidEdit, 1, 1, 1, 2);
	grid->addMultiCellWidget(jidLine, 3, 3, 0, 2);
	// groups
	grid->addMultiCellWidget(new QLabel(i18n("Groups"), plainPage()), 4, 4, 0, 2);
	grid->addWidget(addButton, 5, 0);
	grid->addWidget(removeButton, 6, 0);
	grid->addMultiCellWidget(groupListBox, 5, 7, 1, 2);
	grid->addMultiCellWidget(groupsLine, 8, 8, 0, 2);
	// bottom
	grid->addMultiCellWidget(new QLabel(i18n("Subscriptions"), plainPage()), 9, 9, 0, 2);
	grid->addWidget(subscribeButton, 10, 0);
	grid->addWidget(fromLight, 10, 1);
	grid->addWidget(new QLabel(i18n("Receiving Presence"), plainPage()), 10, 2);
	grid->addWidget(cancelButton, 11, 0);
	grid->addWidget(toLight, 11, 1);
	grid->addWidget(new QLabel(i18n("Sending Presence"), plainPage()) , 11, 2);
	grid->addMultiCellWidget(bottomLine, 12, 12, 0, 2);

	// Now initialize the widgets with the roster item
	jidEdit->setText( item.jid().userHost() );
	QStringList grps = item.groups();
	for(QStringList::Iterator i = grps.begin(); i != grps.end(); ++i)
	{
		QString text = *i;
		if(text.lower() != "unfiled")
			groupListBox->insertItem(text);
	}

	const XMPP::Subscription sub = item.subscription();
	switch(sub.type())
	{
	case XMPP::Subscription::From:
		toLight->on();
		fromLight->off();
		subscribeButton->setEnabled(true);
		cancelButton->setEnabled(true);
		break;
	case XMPP::Subscription::To:
		toLight->off();
		fromLight->on();
		subscribeButton->setEnabled(false);
		cancelButton->setEnabled(true);
		break;
	case XMPP::Subscription::Both:
		toLight->on();
		fromLight->on();
		subscribeButton->setEnabled(false);
		cancelButton->setEnabled(true);
		break;
	case XMPP::Subscription::None:
	default:
		toLight->off();
		fromLight->off();
		subscribeButton->setEnabled(true);
		cancelButton->setEnabled(false);
		break;
	}

	removeButton->setEnabled(groupListBox->currentItem() != -1);
}

void LightHawk::RosterItemDialog::accept(void)
{
	QStringList listGroups;
	for(unsigned i = 0; i < groupListBox->count() ; i++)
		listGroups.append(groupListBox->text(i));

	XMPP::JT_Roster *task = new XMPP::JT_Roster(client.rootTask());
	task->set(item.jid().userHost(), item.name(), listGroups);
	task->go(true);

	KDialogBase::accept();
}

void LightHawk::RosterItemDialog::addClicked(void)
{
	QString message = i18n("What group to you want to add %1 to?").arg( item.jid().userHost() );

	ComboBoxDialog dlg(message, rosterGroups(), this);
	if(dlg.exec() && !groupListBox->findItem(dlg.text()) )
		groupListBox->insertItem(dlg.text());
}

void LightHawk::RosterItemDialog::removeClicked(void)
{
	QString message = i18n("Remove %1 from %2?")
		.arg( item.jid().userHost() )
		.arg( groupListBox->currentText() );

	if( KMessageBox::Yes == KMessageBox::questionYesNo(this, message) )
		groupListBox->removeItem( groupListBox->currentItem() );
}

void LightHawk::RosterItemDialog::subscribeClicked(void)
{
	QString message = i18n("Request subscription?");
	if( KMessageBox::Yes == KMessageBox::questionYesNo(this, message) )
	{
		client.sendSubscription(item.jid(), "subscribe");
		accept();
	}
}

void LightHawk::RosterItemDialog::cancelClicked(void)
{
	QString message = i18n("Cancel subscription?");
	if( KMessageBox::Yes == KMessageBox::questionYesNo(this, message) )
	{
		client.sendSubscription(item.jid(), "unsubscribed");
		accept();
	}
}

void LightHawk::RosterItemDialog::groupCurrentChanged(void)
{
	removeButton->setEnabled(groupListBox->currentItem() != -1);
}

QStringList LightHawk::RosterItemDialog::rosterGroups(void)
{
	QStringList list;
	XMPP::LiveRoster roster = client.roster();
	for(XMPP::LiveRoster::ConstIterator i = roster.begin(); i != roster.end(); ++i)
	{
		QStringList groups = (*i).groups();
		for(QStringList::Iterator j = groups.begin(); j != groups.end(); ++j)
		{
			if(!list.contains(*j)) list.append(*j);
		}
	}
	return list;
}

#include "rosteritemdialog.moc"
// arch-tag: rosteritemdialog.cpp
