// Copyright (C) 2002 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef LIGHTHAWK_ROSTERLISTVIEW_H
#define LIGHTHAWK_ROSTERLISTVIEW_H

#include <klistview.h>

namespace XMPP
{
class Client;
class LiveRosterItem;
class RosterItem;
}

namespace LightHawk
{
class Data;

class RosterListView : public KListView
{
Q_OBJECT

public:
	RosterListView(Data &, XMPP::Client &, QWidget *parent = 0, const char *name = 0);

	void setOnlineOnly(bool);
	bool onlineOnly(void);

	XMPP::RosterItem rosterItem(QListViewItem *);

signals:
	// working around moc's disgraceful lack of namespace awareness
	typedef XMPP::RosterItem RosterItem;
	typedef XMPP::Jid Jid;
	typedef XMPP::Resource Resource;

	// Emitted when a roster item is clicked on
	void contextMenu(const RosterItem &, const QPoint &);
	// Emitted when emptiness is clicked on
	void contextMenu(const QPoint &);
	// Emitted on an execute (enter, double-click, whatever)
	void executed(const RosterItem &);

public slots:
	virtual void clear(void);
	void fill(void);
	void saveCurrentLayout(void);

	void rosterItemAdded(const RosterItem &);
	void rosterItemUpdated(const RosterItem &);
	void rosterItemRemoved(const RosterItem &);
	void resourceAvailable(const Jid &, const Resource &);
	void resourceUnavailable(const Jid &, const Resource &);

private slots:
	void passOnContextMenu(KListView *, QListViewItem *, const QPoint &);
	void passOnExecuted(QListViewItem *);

private:
	QListViewItem *findTreeGroup(const QString &name);

	XMPP::Client &client;

	Data &data;

	bool showOnlineOnly;

	QMap<QListViewItem *, XMPP::RosterItem> itemMap;
};

}
#endif
// arch-tag: rosterlistview.h
