// Copyright (C) 1999 Neil Stevens <neil@hakubi.us>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#include <kaboutdata.h>
#include <kiconloader.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kmainwindow.h>
#include <kpopupmenu.h>
#include <kxmlguifactory.h>
#include <liblighthawk/utils.h>

#include "systemtray.h"

LightHawk::SystemTray::SystemTray(const QString &contextMenu, KMainWindow *parent, const char *name)
	: KSystemTray(parent, name)
{
	setAlignment(AlignHCenter | AlignVCenter);
	menu = (KPopupMenu *)parent->guiFactory()->container(contextMenu, parent);
	const KAboutData *aboutData = KGlobal::instance()->aboutData();
	menu->insertTitle(SmallIcon(aboutData->appName()), aboutData->programName(), 0, 0);
}

void LightHawk::SystemTray::setTitle(const QPixmap &pixmap, const QString &title)
{
	menu->changeTitle(0, pixmap, title);
}

void LightHawk::SystemTray::showEvent(QShowEvent *)
{
	// empty
}

void LightHawk::SystemTray::mousePressEvent(QMouseEvent *event)
{
	if(event->button() == LeftButton)
	{
		if(parentWidget()->isVisible())
			parentWidget()->hide();
		else
			parentWidget()->show();
	}
	else
		menu->popup(event->globalPos());
}

#include "systemtray.moc"
// arch-tag: systemtray.cpp
