/*
 * Copyright (C) 2001, 2002  Justin Karneges
 *                           Akito Nozaki
 *                           Hideaki Omuro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include<qstring.h>

#ifndef JABBER_UTIL_H
#define JABBER_UTIL_H

class SHA1
{
public:
	SHA1();
	static QString digest(QString in);

private:
	struct SHA1_CONTEXT
	{
		Q_UINT32 state[5];
		Q_UINT32 count[2];
		unsigned char buffer[64];
	};

	typedef union {
		unsigned char c[64];
		Q_UINT32 l[16];
	} CHAR64LONG16;

	void transform(Q_UINT32 state[5], unsigned char buffer[64]);
	void init(SHA1_CONTEXT* context);
	void update(SHA1_CONTEXT* context, unsigned char* data, Q_UINT32 len);
	void final(unsigned char digest[20], SHA1_CONTEXT* context);

	unsigned long blk0(Q_UINT32 i);
	bool bigEndian;

	CHAR64LONG16* block;
};

class Base64
{
public:
	static QByteArray encode(const QByteArray &);
	static QByteArray decode(const QByteArray &);
	static QString arrayToString(const QByteArray &);
	static QByteArray stringToArray(const QString &);
};

#endif
// arch-tag: zinv/util.h
