/*
 * Copyright (C) 2001, 2002  Justin Karneges
 *                           Akito Nozaki
 *                           Hideaki Omuro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"vcard.h"
#include"xmlcommon.h"

#include<qdom.h>

using namespace XMPP;

/****************************************************************************
  VCard
****************************************************************************/
VCard::VCard()
{
}

VCard::~VCard()
{
}

QDomElement VCard::toXml(QDomDocument *doc) const
{
	QDomElement v = doc->createElement("vCard");
	v.setAttribute("version", "2.0");
	v.setAttribute("prodid", "-//HandGen//NONSGML vGen v1.0//EN");
	v.setAttribute("xmlns", "vcard-temp");

	if(!field[vFullname].isEmpty())
		v.appendChild(textTag(doc, "FN", field[vFullname]));
	if(!field[vNickname].isEmpty())
		v.appendChild(textTag(doc, "NICKNAME", field[vNickname]));
	if(!field[vDesc].isEmpty())
		v.appendChild(textTag(doc, "DESC", field[vDesc]));
	if(!field[vEmail].isEmpty())
		v.appendChild(textTag(doc, "EMAIL", field[vEmail]));
	if(!field[vBday].isEmpty())
		v.appendChild(textTag(doc, "BDAY", field[vBday]));
	if(!field[vHomepage].isEmpty())
		v.appendChild(textTag(doc, "URL", field[vHomepage]));

	if(1) {
		QDomElement w = doc->createElement("ORG");
		if(!field[vOrgName].isEmpty())
			w.appendChild(textTag(doc, "ORGNAME", field[vOrgName]));
		if(!field[vOrgUnit].isEmpty())
			w.appendChild(textTag(doc, "ORGUNIT", field[vOrgUnit]));
		v.appendChild(w);
	}

	if(!field[vTitle].isEmpty())
		v.appendChild(textTag(doc, "TITLE", field[vTitle]));
	if(!field[vRole].isEmpty())
		v.appendChild(textTag(doc, "ROLE", field[vRole]));
	if(!field[vPhone].isEmpty()) {
		QDomElement w = doc->createElement("TEL");

		QDomElement x = doc->createElement("HOME");
		w.appendChild(x);

		w.appendChild(textTag(doc, "VOICE", field[vPhone]));

		v.appendChild(w);
	}

	if(1) {
		QDomElement w = doc->createElement("ADR");

		QDomElement x = doc->createElement("HOME");
		w.appendChild(x);

		if(!field[vStreet].isEmpty())
			w.appendChild(textTag(doc, "STREET", field[vStreet]));
		if(!field[vExt].isEmpty())
			w.appendChild(textTag(doc, "EXTADD", field[vExt]));
		if(!field[vCity].isEmpty())
			w.appendChild(textTag(doc, "LOCALITY", field[vCity]));
		if(!field[vState].isEmpty())
			w.appendChild(textTag(doc, "REGION", field[vState]));
		if(!field[vPcode].isEmpty())
			w.appendChild(textTag(doc, "PCODE", field[vPcode]));
		if(!field[vCountry].isEmpty())
			w.appendChild(textTag(doc, "COUNTRY", field[vCountry]));

		v.appendChild(w);
	}

	return v;
}

bool VCard::fromXml(const QDomElement &q)
{
	if(q.tagName() != "vcard")
		return FALSE;
	//if(q.attribute("version") != "2.0")
	//	return FALSE;

	//QDomElement xml = q;
	for(QDomNode n = q.firstChild(); !n.isNull(); n = n.nextSibling()) {
		QDomElement i = n.toElement();
		if(i.isNull())
			continue;

		if(i.tagName() == "fn")
			field[vFullname] = tagContent(i);
		else if(i.tagName() == "nickname")
			field[vNickname] = tagContent(i);
		else if(i.tagName() == "desc")
			field[vDesc] = tagContent(i);
		else if(i.tagName() == "email") {
			// email tag is weird.  check parent first
			QString str = tagContent(i);
			if(str.isEmpty()) {
				// check children
				for(QDomNode n = i.firstChild(); !n.isNull(); n = n.nextSibling()) {
					QDomElement e = n.toElement();
					if(e.isNull())
						continue;
					str = tagContent(e);
					if(!str.isEmpty())
						break;
				}
			}
			field[vEmail] = str;
		}
		else if(i.tagName() == "bday")
			field[vBday] = tagContent(i);
		else if(i.tagName() == "url")
			field[vHomepage] = tagContent(i);
		else if(i.tagName() == "org") {
			bool found;
			QDomElement tag = findSubTag(i, "orgname", &found);
			if(found)
				field[vOrgName] = tagContent(tag);
			tag = findSubTag(i, "orgunit", &found);
			if(found)
				field[vOrgUnit] = tagContent(tag);
		}
		else if(i.tagName() == "title")
			field[vTitle] = tagContent(i);
		else if(i.tagName() == "role")
			field[vRole] = tagContent(i);
		else if(i.tagName() == "tel") {
			bool found;
			int type = 0;
			QDomElement tag;

			findSubTag(i, "home", &found);
			if(found)
				type = 1;

			tag = findSubTag(i, "voice", &found);
			if(found) {
				if(type == 1)
					field[vPhone] = tagContent(tag);
			}
		}
		else if(i.tagName() == "adr") {
			bool found;
			int type = 0;
			QDomElement tag;

			findSubTag(i, "home", &found);
			if(found)
				type = 1;
			findSubTag(i, "work", &found);
			if(found)
				type = 2;

			if(type == 1) {
				tag = findSubTag(i, "extadd", &found);
				if(found)
					field[vExt] = tagContent(tag);
				tag = findSubTag(i, "street", &found);
				if(found)
					field[vStreet] = tagContent(tag);
				tag = findSubTag(i, "locality", &found);
				if(found)
					field[vCity] = tagContent(tag);
				tag = findSubTag(i, "region", &found);
				if(found)
					field[vState] = tagContent(tag);
				tag = findSubTag(i, "pcode", &found);
				if(found)
					field[vPcode] = tagContent(tag);
				tag = findSubTag(i, "country", &found);
				if(found)
					field[vCountry] = tagContent(tag);
			}
		}
	}

	return TRUE;
}

bool VCard::isIncomplete() const
{
	for(int n = 0; n < NUM_VCARDFIELDS; ++n) {
		if(!field[n].isEmpty())
			return FALSE;
	}
	return TRUE;
}
// arch-tag: zinv/vcard.cpp
