/*
 * Copyright (C) 2001, 2002  Justin Karneges
 *                           Akito Nozaki
 *                           Hideaki Omuro
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef JABBER_VCARD_H
#define JABBER_VCARD_H

#include<qstring.h>

#define NUM_VCARDFIELDS 17

class QDomDocument;
class QDomElement;

namespace XMPP
{
	// --- VCard-temp 2.0 subset (from non-latest Gabber) ---
	enum {	vFullname, vNickname, vBday, vEmail, vHomepage, vPhone,
		vStreet, vExt, vCity, vState, vPcode, vCountry,
		vOrgName, vOrgUnit, vTitle, vRole, vDesc };

	class VCard
	{
	public:
		VCard();
		~VCard();

		QDomElement toXml(QDomDocument *) const;
		bool fromXml(const QDomElement &);
		bool isIncomplete() const;

		QString field[NUM_VCARDFIELDS];

	private:
		class VCardPrivate *d;
	};
}

#endif
// arch-tag: zinv/vcard.h
