/*
 * xmlcommon.cpp - helper functions for dealing with XML
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"xmlcommon.h"

#include<qdatetime.h>
#include<qdom.h>
#include<qregexp.h>
#include<qstring.h>


bool stamp2TS(const QString &ts, QDateTime *d)
{
	if(ts.length() != 17)
		return false;

	QRegExp re("(\\d\\d\\d\\d)(\\d\\d)(\\d\\dT.*)");
	if(-1 == re.search(ts))
		return false;

	QString dateTimeString = re.cap(1) + "-" + re.cap(2) + "-" + re.cap(3);

	*d = QDateTime::fromString(dateTimeString, Qt::ISODate);
	// Problem is: QDateTime assumed local time, not UTC, so we must offset it

	// Tenchi day
	QDateTime local = QDateTime::fromString("2002-10-10T00:00:00", Qt::ISODate);
	QDateTime utc;
	utc.setTime_t(1034208000);
	int offset = local.secsTo(utc);
	*d = d->addSecs(offset);

	return true;
}

QString TS2stamp(const QDateTime &d)
{
	QDateTime ISOd;
	ISOd.setTime_t(d.toTime_t(), Qt::UTC);
	QString str = ISOd.toString(Qt::ISODate);
	str.replace('-', "");
	return str;
}

QDomElement textTag(QDomDocument *doc, const QString &name, const QString &content)
{
	QDomElement tag = doc->createElement(name);
	QDomText text = doc->createTextNode(content);
	tag.appendChild(text);

	return tag;
}

QString tagContent(const QDomElement &e)
{
	// look for some tag content
	for(QDomNode n = e.firstChild(); !n.isNull(); n = n.nextSibling()) {
		QDomText i = n.toText();
		if(i.isNull())
			continue;
		return i.data();
	}

	return "";
}

QDomElement findSubTag(const QDomElement &e, const QString &name, bool *found)
{
	if(found)
		*found = false;

	for(QDomNode n = e.firstChild(); !n.isNull(); n = n.nextSibling()) {
		QDomElement i = n.toElement();
		if(i.isNull())
			continue;
		if(i.tagName() == name) {
			if(found)
				*found = true;
			return i;
		}
	}

	QDomElement tmp;
	return tmp;
}

QDomElement createIQ(QDomDocument *doc, const QString &type, const QString &to, const QString &id)
{
	QDomElement iq = doc->createElement("iq");
	if(!type.isEmpty())
		iq.setAttribute("type", type);
	if(!to.isEmpty())
		iq.setAttribute("to", to);
	if(!id.isEmpty())
		iq.setAttribute("id", id);

	return iq;
}

QDomElement queryTag(const QDomElement &e)
{
	bool found;
	QDomElement q = findSubTag(e, "query", &found);
	return q;
}

QString queryNS(const QDomElement &e)
{
	bool found;
	QDomElement q = findSubTag(e, "query", &found);
	if(found)
		return q.attribute("xmlns");

	return "";
}

void getErrorFromElement(const QDomElement &e, int *code, QString *str)
{
	bool found;
	QDomElement tag = findSubTag(e, "error", &found);
	if(!found)
		return;

	if(code)
		*code = tag.attribute("code").toInt();
	if(str)
		*str = tagContent(tag);
}
// arch-tag: zinv/xmlcommon.cpp
