/*
 * xmlcommon.h - helper functions for dealing with XML
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef JABBER_XMLCOMMON_H
#define JABBER_XMLCOMMON_H

class QString;
class QDateTime;
class QDomElement;
class QDomDocument;

bool stamp2TS(const QString &ts, QDateTime *d);
QString TS2stamp(const QDateTime &d);
QDomElement textTag(QDomDocument *doc, const QString &name, const QString &content);
QString tagContent(const QDomElement &e);
QDomElement findSubTag(const QDomElement &e, const QString &name, bool *found);
QDomElement createIQ(QDomDocument *doc, const QString &type, const QString &to, const QString &id);
QDomElement queryTag(const QDomElement &e);
QString queryNS(const QDomElement &e);
void getErrorFromElement(const QDomElement &e, int *code, QString *str);

#endif
// arch-tag: zinv/xmlcommon.h
