/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

// utilities for g_markup_xxx

#ifndef UG_MARKUP_H
#define UG_MARKUP_H

#include <stdio.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef	struct	UgMarkup_				UgMarkup;
typedef	enum	UgMarkupState_			UgMarkupState;

// UgInMarkupFunc : how to parse  data in markup.
// UgToMarkupFunc : how to output data to markup.
typedef void	(*UgInMarkupFunc)	(gpointer data, GMarkupParseContext* context);
typedef void	(*UgToMarkupFunc)	(gpointer data, UgMarkup* markup);

//	If you want to skip max 3 level element_start()
//	g_markup_parse_context_push (context, &ug_markup_skip_parser, GINT_TO_POINTER (3));
extern	GMarkupParser		ug_markup_skip_parser;	// GINT_TO_POINTER (n_max_level)

enum UgMarkupState_
{
	UG_MARKUP_ELEMENT_START,	// 0 :  element is not ended.   eg. <element
	UG_MARKUP_ELEMENT_END,		// 1 :  element was ended.      eg. <element/> or </element>
	UG_MARKUP_ELEMENT_TEXT,		// 2 :  element follows text.   eg. <element>text
};

struct UgMarkup_
{
	UgMarkupState	output_state;

	gboolean	formating;
	guint		level;

	FILE*		file;
};

UgMarkup*	ug_markup_new ();
void		ug_markup_free (UgMarkup* markup);

// input
gboolean	ug_markup_input			(const gchar* filename, const GMarkupParser* parser, gpointer data);

// output
gboolean	ug_markup_output_start	(UgMarkup* markup, const gchar* filename, gboolean formating);
void		ug_markup_output_end	(UgMarkup* markup);

void	ug_markup_output_element_start	(UgMarkup* markup, const gchar* printf_format, ...);
void	ug_markup_output_element_end	(UgMarkup* markup, const gchar* element_name);

// If text_len == -1, text is null-terminated.
void	ug_markup_output_text	(UgMarkup* markup, const gchar* text, gint text_len);


#ifdef __cplusplus
}
#endif

#endif  // End of UG_MARKUP_H
