/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <gdk/gdkkeysyms.h>    // for GDK_key...

#include <ug_category_dialog.h>
#include <ug_data_app.h>

#include <glib/gi18n.h>

static gboolean on_key_press_event (GtkWidget* widget, GdkEventKey *event, UgCategoryDialog *dialog);

UgCategoryDialog*	ug_category_dialog_new (const gchar* title, GtkWindow* parent)
{
	UgCategoryDialog*	dialog;
	GtkNotebook*		notebook;
	GtkWidget*			vbox;

	dialog = g_malloc0 (sizeof (UgCategoryDialog));
	dialog->self = (GtkDialog*) gtk_dialog_new_with_buttons (title, parent,
	         (GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	                  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                  GTK_STOCK_OK,     GTK_RESPONSE_OK,
	                  NULL);
	gtk_dialog_set_default_response (dialog->self, GTK_RESPONSE_OK);
	ug_proxy_form_init (&dialog->proxy, TRUE);
	ug_download_form_init (&dialog->download, &dialog->proxy, (GtkWindow*) dialog->self);
	ug_download_form_set_multiple (&dialog->download, TRUE);
	ug_category_form_init (&dialog->category);

	notebook = (GtkNotebook*) gtk_notebook_new ();
	gtk_widget_show ((GtkWidget*) notebook);
	gtk_notebook_append_page (notebook, dialog->category.self, gtk_label_new (_("Category settings")));
	gtk_notebook_append_page (notebook, dialog->download.self, gtk_label_new (_("Default for new download")));

	vbox = dialog->self->vbox;
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) notebook, FALSE, FALSE, 0);
	gtk_widget_show (vbox);

	gtk_container_set_focus_child (GTK_CONTAINER (dialog->self), dialog->category.name_entry);
	g_signal_connect (dialog->category.name_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->download.folder_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->download.referer_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->download.username_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->download.password_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->proxy.host_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->proxy.username_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);
	g_signal_connect (dialog->proxy.password_entry, "key-press-event", G_CALLBACK (on_key_press_event), dialog);

	return dialog;
}

void	ug_category_dialog_destroy (UgCategoryDialog* dialog)
{
	gtk_widget_destroy ((GtkWidget*) dialog->self);
	g_free (dialog);
}

void	ug_category_dialog_get (UgCategoryDialog* dialog, UgCategory* category)
{
	category = category->queuing;

	ug_category_form_get (&dialog->category, category);
	if (category->download_default == NULL)
		category->download_default = ug_dataset_new_app ();

	ug_download_form_get (&dialog->download, category->download_default);
	ug_proxy_form_get (&dialog->proxy, category->download_default);
}

void	ug_category_dialog_set (UgCategoryDialog* dialog, UgCategory* category)
{
	category = category->queuing;

	ug_category_form_set (&dialog->category, category);
	if (category->download_default) {
		ug_download_form_set (&dialog->download, category->download_default);
		ug_proxy_form_set (&dialog->proxy, category->download_default);
	}
}

// ----------------------------------------------------------------------------
//	signal handler
static gboolean on_key_press_event (GtkWidget* widget, GdkEventKey *event, UgCategoryDialog *dialog)
{
	int keyval = event->keyval;

	if (keyval == GDK_Return || keyval == GDK_KP_Enter) {
		gtk_dialog_response (dialog->self, GTK_RESPONSE_OK);
		return TRUE;
	}
	return FALSE;
}

