/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
# if HAVE_NOTIFY
#  include <libnotify/notify.h>
# endif
# if HAVE_GSTREAMER
#  include <gst/gst.h>
# endif
#endif

#define _CRT_SECURE_NO_WARNINGS
#include <string.h>

#ifdef	_WIN32
#ifndef	_WIN32_IE
#define	_WIN32_IE	0x0500
#endif
#include <windows.h>
#include <mmsystem.h>
#endif	// _End of _WIN32

#include <uget.h>

#include <glib/gi18n.h>
#define	NOTIFICATION_TITLE		_("Download Completed")
#define	NOTIFICATION_STRING		_("All queuing downloads have been completed.")

// static void uget_play_sound (const gchar* sound_file);
#ifdef _WIN32
static void uget_play_sound (const gchar* sound_file)
{
	gunichar2*	file_wcs;

	if (g_file_test (sound_file, G_FILE_TEST_EXISTS) == FALSE) {
		gdk_beep ();
		return;
	}

	file_wcs = g_utf8_to_utf16 (sound_file, -1, NULL, NULL, NULL);
	if (PlaySoundW (file_wcs, NULL, SND_ASYNC | SND_FILENAME) == FALSE)
		gdk_beep ();
	g_free (file_wcs);
}

#elif  HAVE_GSTREAMER == 1

static gboolean ugst_bus_func (GstBus* bus, GstMessage* msg, gpointer data)
{
	GstElement*	playbin = data;
	GError*		error   = NULL;

	switch (GST_MESSAGE_TYPE (msg)) {
	case GST_MESSAGE_WARNING:
		gst_message_parse_warning (msg, &error, NULL);
//		g_print ("uget-gtk: gstreamer: %s\n", error->message);
		g_error_free (error);
		break;

	case GST_MESSAGE_ERROR:
		gst_message_parse_error (msg, &error, NULL);
//		g_print ("uget-gtk: gstreamer: %s\n", error->message);
		g_error_free (error);
		// clean up
	case GST_MESSAGE_EOS:
		gst_element_set_state (playbin, GST_STATE_NULL);
		gst_object_unref (GST_OBJECT (playbin));
		break;

	default:
		break;
	}
	return TRUE;
}

static void uget_play_sound (const gchar* sound_file)
{
	GstElement*	playbin = NULL;
	GstBus*		bus     = NULL;
	char*		uri;
	gchar*		file_os;
	extern gboolean	gst_inited;

	if (gst_inited == FALSE) {
		gdk_beep ();
		return;
	}

	file_os = g_filename_from_utf8 (sound_file, -1, NULL, NULL, NULL);
	if (g_file_test (file_os, G_FILE_TEST_EXISTS) == FALSE) {
		g_free (file_os);
		gdk_beep ();
		return;
	}

	playbin = gst_element_factory_make ("playbin", "play");
	if (playbin == NULL) {
		g_free (file_os);
		gdk_beep ();
		return;
	}

	uri = g_filename_to_uri (file_os, NULL, NULL);
	g_free (file_os);

	g_object_set (G_OBJECT (playbin), "uri", uri, NULL);

	bus = gst_pipeline_get_bus (GST_PIPELINE (playbin));
	gst_bus_add_watch (bus, ugst_bus_func, playbin);

	gst_element_set_state (playbin, GST_STATE_PLAYING);

	gst_object_unref (bus);
	g_free (uri);
}

#else
// --disable-gstreamer
static void uget_play_sound (const gchar* sound_file)
{
	gdk_beep ();
}

#endif  // _WIN32

static void uget_notify_by_sound (void)
{
	extern gchar*	uget_path_sounds;
	gchar*			path;

	path = g_build_filename (uget_path_sounds, "uget", "notification.wav",  NULL);
	uget_play_sound (path);
	g_free (path);
}

// uget_notification_xxx ()
#ifdef _WIN32
// ----------------------------------------------------------------------------
// Windows

static	NOTIFYICONDATAW*	pNotifyData = NULL;

// You must use these functions after gtk_status_icon_new()
void	uget_notification_init (void)
{
	pNotifyData = g_malloc0 (sizeof (NOTIFYICONDATAW));

	pNotifyData->cbSize = sizeof (NOTIFYICONDATAW);
	pNotifyData->uFlags = NIF_INFO;			// Use a balloon ToolTip instead of a standard ToolTip.
	pNotifyData->uTimeout = 7000;			// milliseconds, This member is deprecated as of Windows Vista.
	pNotifyData->dwInfoFlags = NIIF_INFO;	// Add an information icon to balloon ToolTip.

	// gtkstatusicon.c
	// (create_tray_observer): WNDCLASS.lpszClassName = "gtkstatusicon-observer"
	pNotifyData->hWnd = FindWindowA ("gtkstatusicon-observer", NULL);
}

void	uget_notification_finalize (void)
{
	g_free (pNotifyData);
}

void	uget_notify_download_completed (Uget* app)
{
	gchar*		string;
	gunichar2*	string_wcs;

	if (pNotifyData->hWnd == NULL)
		return;

	// gtkstatusicon.c
	// (gtk_status_icon_init): priv->nid.uID = GPOINTER_TO_UINT (status_icon);
	pNotifyData->uID = GPOINTER_TO_UINT (app->status_icon);

	string = g_strconcat ("Uget - ", NOTIFICATION_TITLE, NULL);
	string_wcs = g_utf8_to_utf16 (string,  -1, NULL, NULL, NULL);
	wcsncpy (pNotifyData->szInfoTitle, string_wcs, 64 -1);	// null-terminated
	g_free (string);
	g_free (string_wcs);

	string_wcs = g_utf8_to_utf16 (NOTIFICATION_STRING, -1, NULL, NULL, NULL);
	wcsncpy (pNotifyData->szInfo, string_wcs, 256 -1);	// null-terminated
	g_free (string_wcs);

	Shell_NotifyIconW (NIM_MODIFY, pNotifyData);

	uget_notify_by_sound ();
}

#elif HAVE_NOTIFY == 1
// ----------------------------------------------------------------------------
// libnotify
static gboolean	notify_inited = FALSE;

void	uget_notification_init (void)
{
	notify_inited = notify_init ("Uget");
}

void	uget_notification_finalize (void)
{
	if (notify_inited)
		notify_uninit ();
}

void	uget_notify_download_completed (Uget* app)
{
	static	NotifyNotification*	notification = NULL;
	gchar*	title;

	if (notification == NULL) {
		title = g_strconcat ("Uget - ", NOTIFICATION_TITLE, NULL);
		notification = notify_notification_new_with_status_icon (title,
		                                                         NOTIFICATION_STRING,
		                                                         UGET_ICON_NAME,
		                                                         app->status_icon);
		g_free (title);
		notify_notification_set_timeout (notification, 7000);	// milliseconds
	}
	notify_notification_show (notification, NULL);

	uget_notify_by_sound ();
}

#else
// ----------------------------------------------------------------------------
// Run configure with --disable-notify

void	uget_notification_init (void)
{
}

void	uget_notification_finalize (void)
{
}

void	uget_notify_download_completed (Uget* app)
{
	uget_notify_by_sound ();
}

#endif  // _WIN32

