/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.4.1. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BSETTINGS_H
#define C2BSETTINGS_H

#include "c2bColors.h"

#include <settings.h>

#include <QFont>


class QProgressBar;

class c2bSettings : public settings
{

    Q_OBJECT

public:
    ~c2bSettings();

    QFont c2bMonoFont;
    c2bColors colors;
    void notify();
    void update();
    static c2bSettings* initSettings();


signals:
    void newSettings();


private:
    c2bSettings(const QString& organization, const QString& application, QObject* parento = 0);
    c2bSettings(const QString& fn, QObject* parento = 0);

    QProgressBar* progBar;
    void init();
    void processReferenceFile();
    void setDefaults();
#ifdef Q_WS_WIN
    QString decodeFilename(const QString& fn) const;
#endif


private slots:
    void guiExits();
    void processReferenceFileEvent();

};

#define c2bSettingsP (static_cast<c2bSettings*>(settings::instance()))

#endif
