#!/bin/sh

# ***************************************************************
# This shell script compiles and archives GradeL using Gambas2.
# The result is the binary archive gradel, which can be run
# by typing ./gradel from the source directory or installed
# using sudo sh ./install.sh.
# ***************************************************************

VERSION="gradel-0.12.1.gambas"

echo ""
echo "----------------------------------------"
echo "       GradeL Compile Script"
echo "----------------------------------------"
echo "  Checking for compiled components."

# ***************************************************************
#  If the bytecode directory exists, remove all files and the
#  directory.
# ***************************************************************
if [ -d .gambas ]
then
echo "  Removing old files."
cd .gambas
rm *
cd ..
rmdir .gambas
fi

# ***************************************************************
#  If the binary archive already exists, remove it.
# ***************************************************************
if [ -f gradel ]
then
rm gradel
fi

# ***************************************************************
#  If the binary archive already exists, remove it.
# ***************************************************************
if [ -f $VERSION ]
then
rm $VERSION
fi

echo ""
echo "  Compiling GradeL with gbc2 -p -a."

# ***************************************************************
# It is important to include the -p and -a flags
# ***************************************************************
gbc2 -p -a 

echo "  Creating executable archive \"gradel\" with gba2."
gba2 

# ***************************************************************
# Rename executable archive
# ***************************************************************
mv $VERSION gradel

echo "  Compilation complete!"
echo ""
echo "  To run gradel locally type: ./gradel"
echo "  or" 
echo "  sudo \"sh ./install.sh\" to install on Ubuntu."
echo ""

