#!/bin/sh

# ***************************************************************
#  This shell script installs GradeL to the system.
#  Be sure to run compile.sh first.
#  Gradel can be removed from the system with uninstall.sh.
#  The ${DESTDIR} environment variable can be set using export
#  to use a non standard installation directory.  For a standard 
#  installation, set to "".
# ***************************************************************

# ***************************************************************
#  Files and locations
# ***************************************************************
# /usr/bin/gradel
# /usr/share/gradel/gradel.png
# /usr/share/applications/gradel.desktop
# /usr/share/doc/gradel/INSTALL
# /usr/share/doc/gradel/COPYING
# /usr/share/doc/gradel/README
# /usr/share/doc/gradel/ChangeLog
# ***************************************************************

echo ""
echo "------------------------------------------------"
echo "        GradeL Installallation Script"
echo "------------------------------------------------"

# ***************************************************************
#  GradeL binary installs in the /usr/bin directory
# ***************************************************************
echo "  Copying GradeL program to ${DESTDIR}/usr/bin."
mkdir -p ${DESTDIR}/usr/bin
cp gradel ${DESTDIR}/usr/bin

# ***************************************************************
#  Gradel icon installs in /usr/share/gradel directory.
#  GradeL Desktop File installs in /usr/share/applications.
# ***************************************************************
if [ -d ${DESTDIR}/usr/share/gradel ]
then
echo "  Copying GradeL icon to ${DESTDIR}/usr/share/gradel."
cp images/gradel.png ${DESTDIR}/usr/share/gradel
echo "  Copying GradeL Desktop File to ${DESTDIR}/usr/share/applications."
cp gradel.desktop /usr/share/applications
else
echo "  Creating ${DESTDIR}/usr/share/gradel."
mkdir -p ${DESTDIR}/usr/share/gradel
echo "  Copying GradeL icon to ${DESTDIR}/usr/share/gradel."
cp images/gradel.png ${DESTDIR}/usr/share/gradel
echo "  Copying GradeL Desktop File to ${DESTDIR}/usr/share/applications."
cp gradel.desktop /usr/share/applications
fi

# ***************************************************************
#  INSTALL, README, ChangeLog and COPYING install 
#  in /usr/share/doc/gradel
# ***************************************************************
if [ -d ${DESTDIR}/usr/share/doc/gradel ]
then
echo "  Copying INSTALL, README, COPYING, and ChangeLog to ${DESTDIR}/usr/share/doc/gradel"
cp COPYING ${DESTDIR}/usr/share/doc/gradel
cp INSTALL ${DESTDIR}/usr/share/doc/gradel
cp README ${DESTDIR}/usr/share/doc/gradel
cp ChangeLog ${DESTDIR}/usr/share/doc/gradel
else
echo "  Creating ${DESTDIR}/usr/share/doc/gradel."
mkdir -p ${DESTDIR}/usr/share/doc/gradel
echo "  Copying INSTALL, README, COPYING, and ChangeLog to ${DESTDIR}/usr/share/doc/gradel"
cp COPYING ${DESTDIR}/usr/share/doc/gradel
cp INSTALL ${DESTDIR}/usr/share/doc/gradel
cp README ${DESTDIR}/usr/share/doc/gradel
cp ChangeLog ${DESTDIR}/usr/share/doc/gradel
fi

# ***************************************************************
#  Done
# ***************************************************************
echo ""
echo "  Installation complete!  To run type gradel.  Enjoy the program."
echo ""

