#!/bin/sh

# ***************************************************************
#  This shell script removes GradeL to the system.
#  The ${DESTDIR} environment variable can be set using export
#  to use a non standard installation directory.  For a standard 
#  installation, set to "".
# ***************************************************************

echo ""
echo "------------------------------------------------"
echo "         GradeL Uninstall Script"
echo "------------------------------------------------"

# ***************************************************************
#  Remove binary from /usr/bin
# ***************************************************************
echo "  Removing binary from ${DESTDIR}/usr/bin/gradel."
if [ -f ${DESTDIR}/usr/bin/gradel ]
then
echo "  Removing ${DESTDIR}/usr/bin/gradel."
rm ${DESTDIR}/usr/bin/gradel
fi

# ***************************************************************
#  Remove Desktop File
# ***************************************************************
echo "  Removing Desktop File from ${DESTDIR}/usr/share/applications."
if [ -f ${DESTDIR}/usr/share/applications/gradel.desktop ]
then
echo "  Removing ${DESTDIR}/usr/share/applications/gradel.desktop."
rm ${DESTDIR}/usr/share/applications/gradel.desktop
fi

# ***************************************************************
#  Remove icon
# ***************************************************************
echo "  Removing icon from ${DESTDIR}/usr/share/gradel."
if [ -s ${DESTDIR}/usr/share/gradel ]
then
rm ${DESTDIR}/usr/share/gradel/*.*
#rm /usr/share/gradel/*
echo "  Removing ${DESTDIR}/usr/share/gradel."
rmdir ${DESTDIR}/usr/share/gradel
fi

# ***************************************************************
#  Remove docs
# ***************************************************************
echo "  Removing documents from ${DESTDIR}/usr/share/doc/gradel."
if [ -s ${DESTDIR}/usr/share/doc/gradel ]
then
#rm /usr/share/doc/gradel/*.*
rm ${DESTDIR}/usr/share/doc/gradel/*
echo "  Removing ${DESTDIR}/usr/share/doc/gradel."
rmdir ${DESTDIR}/usr/share/doc/gradel
fi

# ***************************************************************
#  Done!
# ***************************************************************
echo ""
echo "  GradeL has been removed from your system."
echo ""

