#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _exe_page_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkWindow\" id=\"window5\">"
"    <property name=\"visible\">True</property>"
"    <property name=\"title\">window2</property>"
"    <child>"
"      <widget class=\"GtkVBox\" id=\"ExePage\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkTable\" id=\"table1\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"n_rows\">3</property>"
"            <property name=\"n_columns\">2</property>"
"            <child>"
"              <widget class=\"GtkLabel\" id=\"label14\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"xalign\">1</property>"
"                <property name=\"label\" translatable=\"yes\">Input:</property>"
"              </widget>"
"              <packing>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\"></property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkComboBox\" id=\"input\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"items\">None"
"Something"
"</property>"
"              </widget>"
"              <packing>"
"                <property name=\"left_attach\">1</property>"
"                <property name=\"right_attach\">2</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\">GTK_FILL</property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkLabel\" id=\"label15\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"xalign\">1</property>"
"                <property name=\"label\" translatable=\"yes\">Output:</property>"
"              </widget>"
"              <packing>"
"                <property name=\"top_attach\">1</property>"
"                <property name=\"bottom_attach\">2</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\"></property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkComboBox\" id=\"output\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"items\">None"
"Something"
"</property>"
"              </widget>"
"              <packing>"
"                <property name=\"left_attach\">1</property>"
"                <property name=\"right_attach\">2</property>"
"                <property name=\"top_attach\">1</property>"
"                <property name=\"bottom_attach\">2</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\">GTK_FILL</property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkLabel\" id=\"label16\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"xalign\">1</property>"
"                <property name=\"label\" translatable=\"yes\">Filter:</property>"
"              </widget>"
"              <packing>"
"                <property name=\"top_attach\">2</property>"
"                <property name=\"bottom_attach\">3</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\"></property>"
"              </packing>"
"            </child>"
"            <child>"
"              <widget class=\"GtkComboBox\" id=\"filter\">"
"                <property name=\"visible\">True</property>"
"                <property name=\"items\">None"
"Something"
"</property>"
"              </widget>"
"              <packing>"
"                <property name=\"left_attach\">1</property>"
"                <property name=\"right_attach\">2</property>"
"                <property name=\"top_attach\">2</property>"
"                <property name=\"bottom_attach\">3</property>"
"                <property name=\"x_options\">GTK_FILL</property>"
"                <property name=\"y_options\">GTK_FILL</property>"
"              </packing>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"expand\">False</property>"
"          </packing>"
"        </child>"
"        <child>"
"          <widget class=\"GtkScrolledWindow\" id=\"scrolledwindow4\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"can_focus\">False</property>"
"            <property name=\"hscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"            <property name=\"vscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"            <property name=\"shadow_type\">GTK_SHADOW_ETCHED_IN</property>"
"            <child>"
"              <widget class=\"GtkTextView\" id=\"textview:MooTextView\">"
"                <property name=\"visible\">True</property>"
"              </widget>"
"            </child>"
"          </widget>"
"          <packing>"
"            <property name=\"position\">1</property>"
"          </packing>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct ExePageXml ExePageXml;

struct ExePageXml {
    MooGladeXML *xml;

    GtkVBox *ExePage;
    GtkComboBox *input;
    GtkComboBox *output;
    GtkComboBox *filter;
    MooTextView *textview;
};

static void
_exe_page_xml_free (ExePageXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static ExePageXml *
exe_page_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
exe_page_xml_build (ExePageXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _exe_page_xml_glade_xml, -1, "ExePage", NULL);
    xml->ExePage = moo_glade_xml_get_widget (xml->xml, "ExePage");
    xml->input = moo_glade_xml_get_widget (xml->xml, "input");
    xml->output = moo_glade_xml_get_widget (xml->xml, "output");
    xml->filter = moo_glade_xml_get_widget (xml->xml, "filter");
    xml->textview = moo_glade_xml_get_widget (xml->xml, "textview:MooTextView");
    g_object_set_data_full (G_OBJECT (xml->ExePage), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _exe_page_xml_free);
}

static ExePageXml *
exe_page_xml_new_empty (void)
{
    ExePageXml *xml = g_new0 (ExePageXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static ExePageXml *
exe_page_xml_new (void)
{
    ExePageXml *xml = exe_page_xml_new_empty ();
    exe_page_xml_build (xml);
    return xml;
}
