#include <mooutils/mooglade.h>
#include <gtk/gtk.h>

const char _lua_page_xml_glade_xml[] =
"<?xml version=\"1.0\"?>"
"<glade-interface>"
"  <widget class=\"GtkWindow\" id=\"window2\">"
"    <property name=\"visible\">True</property>"
"    <property name=\"title\">window2</property>"
"    <child>"
"      <widget class=\"GtkVBox\" id=\"LuaPage\">"
"        <property name=\"visible\">True</property>"
"        <child>"
"          <widget class=\"GtkScrolledWindow\" id=\"scrolledwindow2\">"
"            <property name=\"visible\">True</property>"
"            <property name=\"can_focus\">False</property>"
"            <property name=\"hscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"            <property name=\"vscrollbar_policy\">GTK_POLICY_AUTOMATIC</property>"
"            <property name=\"shadow_type\">GTK_SHADOW_ETCHED_IN</property>"
"            <child>"
"              <widget class=\"GtkTextView\" id=\"textview:MooTextView\">"
"                <property name=\"visible\">True</property>"
"              </widget>"
"            </child>"
"          </widget>"
"        </child>"
"      </widget>"
"    </child>"
"  </widget>"
"</glade-interface>"
;

typedef struct LuaPageXml LuaPageXml;

struct LuaPageXml {
    MooGladeXML *xml;

    GtkVBox *LuaPage;
    MooTextView *textview;
};

static void
_lua_page_xml_free (LuaPageXml *xml)
{
    if (xml)
    {
        g_object_unref (xml->xml);
        g_free (xml);
    }
}

G_GNUC_UNUSED static LuaPageXml *
lua_page_xml_get (gpointer widget)
{
    return g_object_get_data (widget, "moo-generated-glade-xml");
}

static void
lua_page_xml_build (LuaPageXml *xml)
{
    moo_glade_xml_parse_memory (xml->xml, _lua_page_xml_glade_xml, -1, "LuaPage", NULL);
    xml->LuaPage = moo_glade_xml_get_widget (xml->xml, "LuaPage");
    xml->textview = moo_glade_xml_get_widget (xml->xml, "textview:MooTextView");
    g_object_set_data_full (G_OBJECT (xml->LuaPage), "moo-generated-glade-xml",
                            xml, (GDestroyNotify) _lua_page_xml_free);
}

static LuaPageXml *
lua_page_xml_new_empty (void)
{
    LuaPageXml *xml = g_new0 (LuaPageXml, 1);
    xml->xml = moo_glade_xml_new_empty (GETTEXT_PACKAGE);
    return xml;
}

G_GNUC_UNUSED static LuaPageXml *
lua_page_xml_new (void)
{
    LuaPageXml *xml = lua_page_xml_new_empty ();
    lua_page_xml_build (xml);
    return xml;
}
